<?php

use yii\helpers\Html;
use app\customs\CitaPeriodica;

?>

<div id="cita-periodica-modal" class="modal fade modal-solicitud">
    <div class="modal-dialog modal-dialog-centered modal-md">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Repetición de Cita Personalizada</h4>
                <button class="close" data-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="container">
                    <div class="row mt-3">
                        <div class="col-md-4">
                            <p class="mt-3"><strong>Repetir cada</strong></p>
                        </div>
                        <div class="col-md-4">
                            <input type="number" id="rango-repeticion" class="form-control mb-2" min="1" value="1">
                        </div>
                        <div class="col-md-4">
                            <?= Html::dropDownList('periodos', CitaPeriodica::SEMANA, CitaPeriodica::$periodosMenu, ['id'=>'periodos-personalizados', 'class' => 'form-control mb-2']) ?>
                        </div>
                    </div>
                    <div class="row" id="mensaje-mes" style="display: none;">
                        <div class="col-md-12">
                            <p class="mensaje-mes-box" id="mensaje-texto"></p>
                        </div>
                        <div class="col-md-12">
                            <span>*Si un mes no tiene 31 días, se agendará hasta el siguiente posible</span>
                        </div>
                    </div>
                    <div id="dias-semana-inputs" class=" mt-3">
                        <div class="row">
                            <div class="col-md-12">
                                <p class="mt-3"><strong>Se repite el día:</strong></p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <label class="radio-label">
                                    <input type="radio" name="dia-semana" value="<?=CitaPeriodica::DOMINGO?>"/>
                                    <span>D</span>
                                </label>
                                <label class="radio-label">
                                    <input type="radio" name="dia-semana" value="<?=CitaPeriodica::LUNES?>"/>
                                    <span>L</span>
                                </label>
                                <label class="radio-label">
                                    <input type="radio" name="dia-semana" value="<?=CitaPeriodica::MARTES?>"/>
                                    <span>M</span>
                                </label>
                                <label class="radio-label">
                                    <input type="radio" name="dia-semana" value="<?=CitaPeriodica::MIERCOLES?>"/>
                                    <span>Mi</span
                                    ></label>
                                <label class="radio-label">
                                    <input type="radio" name="dia-semana" value="<?=CitaPeriodica::JUEVES?>"/>
                                    <span>J</span>
                                </label>
                                <label class="radio-label">
                                    <input type="radio" name="dia-semana" value="<?=CitaPeriodica::VIERNES?>"/>
                                    <span>V</span>
                                </label>
                                <label class="radio-label">
                                    <input type="radio" name="dia-semana" value="<?=CitaPeriodica::SABADO?>"/>
                                    <span>S</span>
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <p class="mt-4"><strong>¿Cuándo termina la repetición?</strong></p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <label class="radio radio-success">
                                <input type="radio" name="termina-por" checked value="<?=CitaPeriodica::FINAL_POR_FECHA?>">
                                <span></span>El
                            </label>
                        </div>
                        <div class="col-md-6">
                            <input type="text" id="fecha-limite" class="form-control">
                        </div>
                    </div>
                    <div class="row mt-2">
                        <div class="col-md-6">
                            <label class="radio radio-success">
                                <input type="radio" name="termina-por" value="<?=CitaPeriodica::FINAL_POR_REPETICION?>">
                                <span></span>Despues de 
                            </label>
                        </div>
                        <div class="col-md-6">
                            <div class="input-group">
                                <input type="number" id="repeticiones" class="form-control" min="2" value="2">
                                <div class="input-group-append">
                                    <span class="input-group-text" id="texto-repeticiones">repeticiones</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <button type="button" class="btn btn-primary" id="guardar-conf-personalizada">Continuar</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->