<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use app\assets\HorarioAsset;
use app\models\Usuario;
/* @var $this yii\web\View */
/* @var $model app\models\HorarioMedico */
/* @var $usuario app\models\Usuario */
/* @var $form yii\widgets\ActiveForm */
$horarios = [1 => 'Domingo',2 => 'Lunes', 3 => 'Martes', 4 => 'Miercoles', 5 => 'Jueves', 6 => 'Viernes', 7 => 'Sábado'];
$usuario = Yii::$app->user->identity;
HorarioAsset::register($this);
?>





<?php $form = ActiveForm::begin(['options' => ['class' => 'kt-form']]); ?>
    <div class="horario-medico-form kt-portlet__body">
        <?php if($usuario->tipo == Usuario::DOCTOR){ ?>
        <div class="row">
            <div class="col-lg-12"><?= $form->field($model, 'id_clinica')->dropDownList($clinicas) ?></div>
        </div>
        <?php } ?>
        <div class="row">
            <div class="col-lg-4"><?= $form->field($model, 'dia')->dropDownList($horarios) ?></div>
            <div class="col-lg-4"><?= $form->field($model, 'hora_inicio')->textInput() ?></div>
            <div class="col-lg-4"><?= $form->field($model, 'hora_fin')->textInput() ?></div>
        </div>
    </div>
    <div class="kt-portlet__foot">
        <div class="form-group kt-form__actions">
            <?= Html::submitButton('Guardar', ['class' => 'btn btn-success']) ?>
        </div>
    </div>
<?php ActiveForm::end(); ?>
