<?php

use app\customs\StripeUtils;

/* @var $this yii\web\View */
/* @var $suscripcion Stripe\Subscription */

?>

<?php if($estado_suscripcion == StripeUtils::ESTADO_ACTIVA) { ?>
    <p>Tu plan está activo y funcionando.<br>
        Tu próximo pago es de <strong>$<?=$plan->precio?></strong> más sobrecargos (de existir citas extras) y se realizará el día <?=date('d/m/Y',$suscripcion->current_period_end)?>.<br>  
    </p>
<?php } else if($estado_suscripcion == StripeUtils::ESTADO_PRUEBA){ ?>
    <p>
        Tu plan de prueba terminará el <?= date('d/M/y',$suscripcion->trial_end)?>. Tienes hasta ese día para disfrutar de los beneficios de olivia Health<br> 
        ¡No vuelvas a procesos anteriores en donde pierdes pacientes, tiempo y dinero!<br>
        Haz click en el botón, registra una forma de pago y empieza a disfrutar de los beneficios de Olivia Health.
    </p>
<?php   
} else if($estado_suscripcion == StripeUtils::ESTADO_SIN_FORMA_PAGO || $estado_suscripcion == StripeUtils::ESTADO_SIN_SUSCRIPCION){ ?>
    <p>
       Tu plan de prueba ha terminado y no has ingresado una forma de pago.<br> 
       ¡No vuelvas a procesos anteriores en donde pierdes pacientes, tiempo y dinero!<br>
       Ingresa una tarjeta haciendo click en el botón y continúa tomando el control de tu consultorio.<br>
    </p>
<?php   
} else if($estado_suscripcion == StripeUtils::ESTADO_CANCELADA){ ?>
    <p>
        Tu suscripción ha sido cancelada, por favor ponte en contacto con el personal de Olivia Health.
    </p>
<?php   
} else if($estado_suscripcion == StripeUtils::ESTADO_INCOMPLETA || $estado_suscripcion == StripeUtils::ESTADO_INCOMPLETA_EXPIRADA){ ?>
    <p>
        Tu plan no está activo debido a que tu fecha de corte ya pasó y no se ha realizado ningún pago.<br>
        Puede que hayas desenlazado tu tarjeta o que haya problemas con aquella que introdujiste anteriormente.<br>
        Haz click en el botón y añade una nueva forma de pago.<br>
    </p>
<?php   
}
?>