<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\file\FileInput;

/* @var $this yii\web\View */
/* @var $model app\models\FirmaMedico */
/* @var $form yii\widgets\ActiveForm */
?>

<?php $form = ActiveForm::begin(['options' => ['class' => 'kt-form']]); ?>
    <div class="clinica-form kt-portlet__body">

        <div class="row">
            <div class="col-lg-12">
                <ul>
                    <li>La imagen de tu firma y sello debe de estar en .jpg o .png.</li>
                    <li>Se recomienda usar una imagen escaneada para une major defición. Y con dimensiones de 200px X 200px</li>
                </ul>
            </div>
        </div>    
        <div class="row">
            <div class="col-lg-12">
                <?= $form->field($model, 'firma')->widget(FileInput::classname(), [
                    'model' => $model,
                    'attribute' => 'firma',
                    'name' => 'firma',
                    'options' => [
                        'accept' => ['image/*'], 
                        'multiple' => false
                        ],
                    'pluginOptions'=>[
                        'maxFileCount' => 1,
                        'allowedFileExtensions'=>['jpg', 'png', 'jpeg'],
                        'showUpload' => false,
                        'showRemove' => true,
                        'overwriteInitial' => true,
                        ],
                ]);?>
            </div>
        </div>  
    </div>
    <div class="kt-portlet__foot">
        <div class="form-group kt-form__actions">
            <?= Html::submitButton('Guardar', ['class' => 'btn btn-success']) ?>
        </div>
    </div>
<?php ActiveForm::end(); ?>