<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use app\assets\EventoAsset;
use app\models\Usuario;
/* @var $this yii\web\View */
/* @var $model app\models\Evento */
/* @var $usuario app\models\Usuario */
/* @var $form yii\widgets\ActiveForm */

EventoAsset::register($this);
$privacidad = [0 => 'público', 1 => 'privado'];

$usuario = Yii::$app->user->identity;

if($usuario->tipo == Usuario::ASISTENTE){
    $model->privacidad = 0;
}
?>

<?php $form = ActiveForm::begin(['options' => ['class' => 'kt-form', 'autocomplete' => 'off']]); ?>
    <div class="evento-form kt-portlet__body">
        <div class="row">
            
            <div class="col-lg-2 col-md-2">
                <?php if($usuario->tipo == app\models\Usuario::DOCTOR){ ?>
                <?= $form->field($model, 'privacidad')->radioList($privacidad) ?>
                <?php }else{ ?>
                <?= $form->field($model, 'privacidad')->hiddenInput()->label(false) ?>
                <?php } ?>
            </div>
            <div class="col-lg-2 col-md-2">
                <label class="form-label">¿Todo el día?</label>
                <?= $form->field($model, 'todo_dia')->checkbox(['label' => null]) ?>
            </div>
            <div class="col-lg-4"><?= $form->field($model, 'fecha_inicio')->textInput() ?></div>
            <div class="col-lg-4"><?= $form->field($model, 'fecha_fin')->textInput() ?></div>
        </div>
        <div class="row">
            <div class="col-lg-4"><?= $form->field($model, 'nombre')->textInput(['maxlength' => true]) ?></div>
            <div class="col-lg-8"><?= $form->field($model, 'descripcion')->textInput(['maxlength' => true]) ?></div>
        </div>


        

    

    

    

    

    </div>
    <div class="kt-portlet__foot">
        <div class="form-group kt-form__actions">
            <?= Html::submitButton('Guardar', ['class' => 'btn btn-success']) ?>
        </div>
    </div>
<?php ActiveForm::end(); ?>