<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model app\models\Configuracion */
/* @var $form yii\widgets\ActiveForm */
$confs = $model->isNewRecord ? ['maxlength' => true] : ['maxlength' => true,'readonly' => 'readonly'];

?>

<?php $form = ActiveForm::begin(['options' => ['class' => 'kt-form']]); ?>
    <div class="configuracion-form kt-portlet__body">
        <div class="row">
            <div class="col-md-4"><?= $form->field($model, 'nombre')->textInput(['maxlength' => true]) ?></div>
            <div class="col-md-8"><?= $form->field($model, 'descripcion')->textInput(['maxlength' => true]) ?></div>
        </div>
        <div class="row">
            <div class="col-md-4"><?= $form->field($model, 'tipo')->dropDownList(app\models\Configuracion::TIPOS) ?></div>
            <div class="col-md-8"><?= $form->field($model, 'posibles_valores')->textInput() ?></div>
        </div>
        <div class="row">
            <div class="col-md-6"><?= $form->field($model, 'llave')->textInput($confs) ?></div>
            <div class="col-md-6"><?= $form->field($model, 'valor')->textInput(['maxlength' => true]) ?></div>
        </div>
        <div class="row">
            <div class="col-md-4"><?= $form->field($model, 'es_suscripcion')->checkbox()?></div>
            <div class="col-md-4"><?= $form->field($model, 'es_clinica')->checkbox()?></div>
            <div class="col-md-4"><?= $form->field($model, 'orden')->textInput(['maxlength' => true]) ?></div>
        </div>
        
        

    

    

    </div>
    <div class="kt-portlet__foot">
        <div class="form-group kt-form__actions">
            <?= Html::submitButton('Guardar', ['class' => 'btn btn-success']) ?>
        </div>
    </div>
<?php ActiveForm::end(); ?>