<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use app\models\UsuarioSuscripcion;
use app\assets\ColegaAsset;
use app\models\GrupoTrabajoUsuario;

/* @var $this yii\web\View */ 
/* @var $model app\models\Usuario */
/* @var $usuario app\models\Usuario */
/* @var $perfil app\models\Perfil */
/* @var $usuarioSuscripcion app\models\UsuarioSuscripcion */
/* @var $form yii\widgets\ActiveForm */

ColegaAsset::register($this);

$usuario = Yii::$app->user->identity;

$gruposSeleccionados = $model->isNewRecord ? [] : GrupoTrabajoUsuario::find()->where(['id_usuario' => $model->id])->select('id_grupo')->column();

$this->registerCss("
    .grupo-select2-container .select2-selection__rendered{
        padding-top: 0 !important;
        padding-bottom: 0 !important;
    
        padding-left: 8px !important;
        padding-right: 20px !important;
    }

    .grupo-select2-container .select2-selection__arrow{
        top: 50% !important;
    }
");
?>

<?php $form = ActiveForm::begin(['options' => ['class' => 'kt-form']]); ?>
    <div class="usuario-form kt-portlet__body">
        <div class="row">
            <div class="col-6"><?= $form->field($perfil, 'nombre')->textInput(['maxlength' => true]) ?></div>
            <div class="col-6"><?= $form->field($perfil, 'apellidos')->textInput(['maxlength' => true]) ?></div>
        </div>
        <div class="row">
             <?php if($model->isNewRecord){ ?>
            <div class="col-6"><?= $form->field($model, 'nombre_usuario',['enableAjaxValidation' => true])->label("Correo de usuario")->textInput(['maxlength' => true]) ?></div>
            <?php }else{ ?>
            <div class="col-6"><?= $form->field($model, 'nombre_usuario')->label("Correo de usuario")->textInput(['maxlength' => true, 'readonly' => 'readonly']) ?></div>
            <?php } ?>
            <div class="col-6"><?= $form->field($perfil, 'telefonos')->textInput(['maxlength' => true])->widget(\yii\widgets\MaskedInput::className(), [
    'mask' => '9999-9999',]) ?></div>
        </div>
        <div class="row">
            <div class="col-6">
                <div class="form-group">
                    <label>Tipo</label>
                    <?php if($usuario->tipoUsuarioJerarquia == UsuarioSuscripcion::TIPO_COORDINADOR){ ?>
                    <?= Html::dropDownList("tipo",$usuarioSuscripcion->tipo, UsuarioSuscripcion::$tipoCoordinador,['class' => 'form-control','id' =>'tipo'])?>
                    <?php } else { ?>
                    <?= Html::dropDownList("tipo",$usuarioSuscripcion->tipo,UsuarioSuscripcion::$tipos,['class' => 'form-control','id' =>'tipo'])?>
                    <?php } ?>
                    
                </div>
            </div>
            <div class="col-6">
                <div class="form-group grupo-select2-container">
                    <label>Grupo</label>
                    <?= Html::dropDownList("grupo",$gruposSeleccionados,$grupos,['class' => 'form-control','id' =>'grupo', 'multiple' => ($usuarioSuscripcion->tipo == UsuarioSuscripcion::TIPO_ASISTENTE)])?>
                </div>
            </div>
            <?= $form->field($model, 'id_rol')->hiddenInput(['id' => 'id_rol'])->label(false)?>
        </div> 
    </div>
    <div class="kt-portlet__foot">
        <div class="form-group kt-form__actions text-right">
            <?= Html::submitButton('Guardar', ['class' => 'btn btn-success']) ?>
        </div>
    </div>
<?php ActiveForm::end(); ?>

<div id="asociar-modal" class="modal fade">
    <div class="modal-dialog modal-dialog-centered modal-md">
        <div class="modal-content" id="_ViewSegCont">
            <div class="modal-header">
                <h4 class="modal-title">Usuario Existente</h4>
                <button class="close" data-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>¿Ya existe un usuario con el correo ingresado desea asociarlo a su suscripción?</p>
            </div>
            <div class="modal-footer" >
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" id="asociar">Asociar</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->