<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\file\FileInput;

/* @var $this yii\web\View */
/* @var $model app\models\Clinica */
/* @var $form yii\widgets\ActiveForm */
?>

<?php $form = ActiveForm::begin(['options' => ['class' => 'kt-form']]); ?>
    <div class="clinica-form kt-portlet__body">
        <div class="row">
            <div class="col-lg-4"><?= $form->field($model, 'nombre')->textInput(['maxlength' => true]) ?></div>
            <div class="col-lg-4"><?= $form->field($model, 'telefono')->textInput(['maxlength' => true]) ?></div>
            <div class="col-lg-4"><?= $form->field($model, 'celular')->textInput(['maxlength' => true]) ?></div>
        </div>
        <div class="row">
            <div class="col-lg-12"><?= $form->field($model, 'direccion')->textInput(['maxlength' => true]) ?></div>
        </div>
        <hr>
        <div class="row">
            <div class="col-lg-12">
                <ul>
                    <li>La imagen de tu logo debe de estar en .jpg o .png.</li>
                    <li>Las medidas deben de ser entre 200 a 300 pixeles por lado.</li>
                </ul>
            </div>
        </div>    
        <div class="row">
            <div class="col-lg-12">
                <?= $form->field($model, 'logo')->widget(FileInput::classname(), [
                    'model' => $model,
                    'attribute' => 'logo',
                    'name' => 'logo',
                    'options' => [
                        'accept' => ['image/*'], 
                        'multiple' => false
                        ],
                    'pluginOptions'=>[
                        'maxFileCount' => 1,
                        'allowedFileExtensions'=>['jpg', 'gif', 'png', 'jpeg'],
                        'showUpload' => false,
                        'showRemove' => true,
                        'overwriteInitial' => true,
                        ],
                ]);?>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="col-lg-12">
                <ul>
                    <li>Recuerda que las medidas de tu imagen deben de estar comprendidas entre los 200 a 300 pixeles por lado.</li>
                </ul>
            </div>
        </div>    
        
    </div>
    <div class="kt-portlet__foot">
        <div class="form-group kt-form__actions">
            <?= Html::submitButton('Guardar', ['class' => 'btn btn-success']) ?>
        </div>
    </div>
<?php ActiveForm::end(); ?>