<?php

use yii\helpers\Html;
use yii\web\YiiAsset;
use app\assets\ViewCitaAsset;
use app\models\Usuario;
use yii\helpers\Url;
use app\models\Cita;
use app\models\repositories\SecurityFunctions;
use app\models\Pagadito;

/* @var $this yii\web\View */
/* @var $model app\models\Cita */
/* @var $usuario app\models\Usuario */
/* @var $pagadito app\models\Pagadito */
/* @var $cobroCita app\models\CobroPagadito */

$securityFunctions = new SecurityFunctions;
$usuario = Yii::$app->user->identity;
$simboloMoneda = $usuario->suscripcion->pais->simbolo;

$paciente = $model->paciente;
$cobroCita = $model->cobroPagadito;

$boolCobroPasarela = $pagadito != null ? \boolval( $pagadito->cobrar_pasarela ) : false;

$boolMarcarAsistencia = ($usuario->tipo == Usuario::DOCTOR || ($usuario->tipo == Usuario::ASISTENTE && 
        $securityFunctions->accionPermitida("confirmar-cita", "cita"))) && 
        ($model->estado < 3 && (time() >= strtotime($model->fechaDB)));

$boolConfPagadito = $usuario->tipo == Usuario::DOCTOR && $medioPagoCita === Pagadito::MEDIO_PAGO_PAGADITO && $cobroCita == NULL && $pagadito == NULL;

$boolDetalleCobro = ($medioPagoCita === Pagadito::MEDIO_PAGO_PAGADITO || $medioPagoCita === Pagadito::MEDIO_PAGO_LINK) && 
        $cobroCita != NULL && $pagadito != NULL;

$boolCobrarCita = ($model->estado != Cita::CANCELADA || $model->estado != Cita::INASISTENCIA) && 
        ($medioPagoCita == Pagadito::MEDIO_PAGO_PAGADITO || ($medioPagoCita == Pagadito::MEDIO_PAGO_LINK && !empty($pagadito->link_externo))) && 
        $cobroCita == NULL && $pagadito != NULL;

        
$this->title = $model->paciente->nombreCompleto;
$this->params['breadcrumbs'][] = ['label' => 'Citas', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
YiiAsset::register($this);
ViewCitaAsset::register($this);
?>
<script>
    var existCitaProx = '<?=$existCitaProx ? 'true' : 'false'?>';
    var isCreateCita = '<?=$createCita ? 'true' : 'false'?>';
    var reprogramar = '<?=boolval($reprogramar) ? 'true' : 'false'?>';
    var fecha_anterior = '<?=$fecha_anterior?>';
    var id_cita = '<?=$model->id?>';
    var init_fns_cobro = '<?= $model->cobroPagadito == NULL ? 1 : 0 ?>'-0;
</script>
<style>
.check{
  -ms-transform: scale(1.2);
  -moz-transform: scale(1.2); 
  -webkit-transform: scale(1.2); 
  -o-transform: scale(1.2);
  padding: 10px;
  margin: 5px 5px;
}

.custom-fade{
    padding-right: 17px; 
    display: block;
}
</style>
<div class="kt-portlet__body" style="text-shadow: none;">
    <div class="kt-widget kt-widget--user-profile-3" style="text-shadow: none;">
        <div class="kt-widget__top" style="text-shadow: none;">
            <div class="kt-widget__content">
                <div id="fecha-cita-str" data-fecha="<?= \date('d/m/Y', strtotime($model->fechaDB)) ?>&nbsp;<?= \date('H:i', strtotime($model->fechaDB)) ?>"></div>
            </div>
        </div>
        <div class="kt-widget__top" style="text-shadow: none;">
            <div>
                <div class="btn-group" style="margin-left: -8px;">
                    <button type="button" class="btn btn-secondary btn-md dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="margin-left: 0 !important;">
                        Opciones
                    </button>
                    <div class="dropdown-menu">
                        <?= Html::a('<i class="la la-edit kt-font-primary mt-2"></i>Actualizar', ['update', 'id' => $model->id], ['class' => 'dropdown-item']) ?>
                        <?php if( $model->estado < Cita::COMPLETADA ):?>
                        <a class='dropdown-item' href='#' data-toggle='modal' data-target='#id_1'>Cambiar Estado</a>
                        <?php endif;?>
                        <div class="dropdown-divider"></div>
                        <?= Html::a('<i class="la la-print kt-font-primary mt-2"></i>Imprimir', ['reportes/imprimir-cita', 'id_cita' => $model->id], ['class' => 'dropdown-item', 'target'=>'_blank']) ?>
                        <?php if($model->estado < Cita::CANCELADA ):?>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item" href="#" id="cancelar-cita" data-id="<?=$model->id?>"><i class="la la-trash kt-font-danger mt-2"></i>Cancelar Cita</a>                        
                        <?php endif;?>
                    </div>
                </div>
                <?php if ( $boolMarcarAsistencia ) : ?>
                    <button class="btn btn-success mt-1" id="nf-<?= $model->id ?>" onclick="confirmar(<?= $model->id ?>)" data-toggle="kt-tooltip" data-placement="top" title="¿Asistió el pacinte a su cita?" data-original-title="¿Asistió?">¿Asistió?</button>
                <?php endif;?>
                <?php if( $boolCobrarCita ):?>
                    <button  data-toggle="modal" data-target="#cobrar-cita-modal" class="btn btn-success mt-1" data-id="<?=$model->id?>">Cobrar</button>
                <?php endif;?>
                <?php if( $boolConfPagadito ):?>
                    <?= Html::a('Configurar Pagadito', ['settings/index'], ['class'=>'btn btn-primary'])?>
                <?php endif;?>
                <?php if($usuario->tipo == Usuario::ASISTENTE  && $medioPagoCita === Pagadito::MEDIO_PAGO_PAGADITO && $model->cobroPagadito == NULL && $pagadito == NULL):?>
                    <span style="font-size: 12px;" class="kt-badge kt-badge--brand kt-badge--inline kt-badge--pill kt-badge--rounded">Configure cuenta de Pagadito</span>
                <?php endif;?>        
                <?php if( $boolDetalleCobro ):?>
                    <button data-toggle="modal" data-target="#detalle-cobro-modal" class="btn btn-success mt-1">Detalle Cobro</button>
                <?php endif;?>    
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12" >
                <div class="kt-separator kt-separator--space-md kt-separator--border-dashed mt-3" style="border-color: white;"></div>
                <div class="kt-widget1 kt-widget1--fit">
                    <div class="kt-widget1__item">
                        <div class="kt-widget1__info">
                            <h3 class="kt-widget1__title">Asunto</h3>
                            <span class="kt-widget1__desc">
                                <?= ($model->asunto == '') ? "(No definido)" : $model->asunto; ?>
                            </span>
                        </div>
                    </div>
                    <div class="kt-widget1__item">
                        <div class="kt-widget1__info">
                            <h3 class="kt-widget1__title">Diagnóstico</h3>
                            <span class="kt-widget1__desc"><?= $model->diagnostico != null ? Html::a('Ver más', ['update', 'id' => $model->id], ['class' => '']) : 'No definido' ?></span>
                        </div>
                    </div>
                    <div class="kt-widget1__item">
                        <div class="kt-widget1__info">
                            <h3 class="kt-widget1__title" style="padding-bottom: 20px;">Procedimientos</h3>
                            <?php
                            foreach ($procedimiento_cita_array as $model_cli_pro) {
                                echo " <li style='margin-top:-15px;' class='kt-widget1__desc'>" . $model_cli_pro->procedimiento->nombre . "</li><br>";
                            }
                            ?>
                        </div>
                    </div>
                    <div class="kt-widget1__item">
                        <div class="kt-widget1__info">
                            <h3 class="kt-widget1__title"><?= $model->totalRecordatorios == 0 ? "Ningún" : $model->totalRecordatorios . "°" ?> recordatorio enviado:</h3>
                            <span class="kt-widget1__desc"><?= $model->textoEstado ?></span>
                        </div>
                    </div>
                    <div class="kt-widget1__item">
                        <div class="kt-widget1__info">
                            <h3 class="kt-widget1__title">Tiempo de duración</h3>
                            <span class="kt-widget1__desc"><?= $model->tiempo_estimado ?></span>
                        </div>
                    </div>
                    <div class="kt-widget1__item">
                        <div class="kt-widget1__info">
                            <h3 class="kt-widget1__title">Costo</h3>
                            <?php
                            $sum_costos = 0;
                            foreach ($procedimiento_cita_array as $model_cli_pro) {
                                $sum_costos += $model_cli_pro->costo_editado;
                            }
                            echo " <span class='kt-widget1__desc'>". $simboloMoneda.$sum_costos . "</span><br>";
                            ?>
                        </div>
                    </div>
                    <div class="kt-widget1__item">
                        <div class="kt-widget1__info">
                            <h3 class="kt-widget1__title">Tipo de Cita</h3>
                            <span class="kt-widget1__desc"><?= $model->tipo_cita == Cita::CITA_PRESENCIAL ? 'Cita Presencial' : 'Cita en Línea' ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="confirmarCitaModal" class="modal fade">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Confirmar</h4>
                <button class="close"></button>
            </div>
            <div class="modal-body">
                <p>¿El paciente asistió a su cita?</p>
            </div>
            <div class="modal-footer">
                <button id="btn-confirmarCitaModalNo" class="btn btn-sm btn-default">No</button>
                <button id="btn-confirmarCitaModalYes" class="btn btn-sm btn-primary">Sí</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<div class="modal fade" role="dialog" aria-hidden="true" id="cambiar-estado">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Cambiar el estado de la cita de <?= $model->paciente->nombreCorto ?></h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
            </div>
            <div class="modal-body">
                <?= Html::beginForm(Url::toRoute([""]), "POST") ?>
                <input type="hidden" name="id" id="id_cita" value="<?= $model->id ?>">   
                <label>Selecciona uno de los siguientes Estados</label>
                <select name="estado"  id="estado" class="form-control" required>
                    <option value="">-Seleccionar estado-</option>                                                                
                    <option value="<?= Cita::CONFIRMADA?>">Confirmada</option>
                    <option value="<?= Cita::CANCELADA?>">Cancelada</option>
                </select>
            </div>
            <div class="modal-footer">

                <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                <?= Html::button('Continuar', ['id'=>'btn-estado', 'class' => 'btn btn-success']) ?>
                <?= Html::endForm() ?>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<?= $this->render('../modals/cobro-cita', [
    'model' => $model,
    'pagadito' => $pagadito,
    'cobroCita' => $cobroCita,
    'paciente' => $paciente,
    'medioPagoCita' => $medioPagoCita,
    'boolCobroPasarela' => $boolCobroPasarela,
    'procedimiento_cita_array' => $procedimiento_cita_array
])?>
