<?php

use yii\helpers\Html;
use yii\grid\GridView;
use app\models\Cita;
use yii\widgets\ActiveForm;
use yii\helpers\Url;
use app\assets\ReporteCitaAssets;
use app\models\Suscripcion;


/* @var $this yii\web\View */
/* @var $model app\models\Paciente */
/* @var $usuario Usuario */
/* @var $suscripcion app\models\Suscripcion */
/* @var $searchModel  app\models\CitaSearch  */
/* @var $dataProvider yii\data\ActiveDataProvider */

$usuario = Yii::$app->user->identity;
$suscripcion = $usuario->suscripcion;

$today = date("Y-m-d");
$endweek = strtotime($today."+ 7 days");
$_now = strtotime($today);
$this->title = 'Citas';
$this->params['breadcrumbs'][] = $this->title;


ReporteCitaAssets::register($this);
?>
<div class="cita-index kt-portlet">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
        <p class="mt-2">
            <?= Html::a('Crear Cita', ['create'], ['class' => 'btn btn-success']) ?>            
            <a class="btn btn-dark my-4 mb-2" id="btn-excel" href="#" data-toggle="modal" data-target="#_dialog"><i class="flaticon-download-1"></i>Descargar Excel</a>
        </p>
    </div>
    
    <div class="kt-portlet__body">
        
    <?php if($suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL) { ?>
        <p>
            <?= $this->render('../layouts/_filtro_clinica', ['clinicas' => $clinicas, 'clinicas_seleccionadas' => $clinicas_seleccionadas]) ?>
        </p>
    <?php } ?>

        <div class="table-responsive">
            <?=
            GridView::widget([
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'tableOptions' => ['class' => 'table table-hover', 'style' => 'font-size: 11pt'],
                'summary' => 'Mostrando {begin} - {end} de {totalCount} ítems',
                'filterRowOptions' => ['class' => 'kt-hide'],
                'rowOptions' => function ($model) {
                    return ['data-id' => $model->id];
                },
                'columns' => [
                    'fecha',
                    'nombrePaciente',
                    'nombreClinica',
                    [
                        'label' => 'Asunto',
                        'value' => function ($model) {
                            return ($model->asunto == '') ? null : $model->asunto;
                        }
                    ],
                    'textoEstado',
                    [
                        'class' => 'app\customs\ActionColumn',
                        'template' => '{view} {update} {delete}',
                        'buttons' => [
                            'update' => function ($url, $model, $key) {
                                return $model->estado >= Cita::CANCELADA 
                                ? "" 
                                : Html::a('<span class="kt-font-warning flaticon-edit"></span>', ['update', 'id' => $model->id]);
                            },
                            'delete' => function ($url, $model, $key) {
                                return $model->estado >= Cita::CANCELADA  
                                ? "" 
                                : ( $model->esCitaPeriodica 
                                    ? '<span class="kt-font-danger flaticon-cancel cancelar-cita-periodica" data-id="'.$model->id.'" data-tokencita="'.$model->cita_periodica_token.'" data-fecha="'.$model->fechaDB.'"></span>' 
                                    : Html::a('<span class="kt-font-danger flaticon-cancel"></span>', ['delete', 'id' => $model->id], ['data-method' => 'post', 'data-confirm' => '¿Está seguro de cancelar la cita?'])
                                );
                            },
                        ]
                    ],
                ],
            ]);
            ?>
            <?php
                $this->registerJs("
                    $('tbody td:not(.disable-click)').css('cursor', 'pointer');
                    $(document).on('click','table tr td:not(.disable-click)',function(e) {      
                        var id = $(this).closest('tr').data('id');
                        if (e.target == this && id)
                            location.href = '" . Url::to(['/cita/view']) . "?id=' + id;
                    });
                    $('.cancelar-cita-periodica').click( e => {
                        const { id, tokencita, fecha } = e.target.dataset;
                        $('#cancelar-todas-periodicas').attr('data-token', tokencita);
                        $('#cancelar-todas-periodicas').attr('data-fecha', fecha);
                        $('#cancelar-individual-periodica').attr('data-id', id);
                        $('#cancelar-cita-periodica-modal').modal('show');
                    });
                    $('#cancelar-todas-periodicas').click( e => {
                        const cita_periodica_token = e.target.dataset.token;
                        const fecha = e.target.dataset.fecha;
                        $.post( _baseURL + '/cita/cancelar-cita', 
                            { cita_periodica_token, fecha }, 
                            (json) => json.Correcto && location.reload(), 
                        'json');
                    });
                    $('#cancelar-individual-periodica').click( e => {
                        const id = e.target.dataset.id;
                        $.post( _baseURL + '/cita/cancelar-cita', 
                            { id }, 
                            (json) => json.Correcto && location.reload(), 
                        'json');
                    });
                ");
                ?>
        </div>


    </div>
</div>
<div class="modal fade" role="dialog" aria-hidden="true" id="_dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Exportar Citas</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
            </div>
            <div class="modal-body container">
                <?php $form = ActiveForm::begin([
                    'class' => 'kt-form',
                    'action' => Url::toRoute(['reportes/excel-citas']),
                    ]);?>
                <div class="row-fluid">
                    <div class="form-group" id="opt-citas">
                        <label class="radio-inline"><input type="radio" value="week" name="optradio" checked> Citas de la semana</label>
                        <label class="radio-inline"><input type="radio" value="custom" name="optradio"> Rango de fechas</label> 
                    </div>
                </div>
                <div id="fecha-semana-group" class="row campos-filtro-citas">
                    <div class="form-group col-sm-6">
                        <label class="form-label" for="fecha-inicio-semana">Citas de la Semana</label>
                        <input id="fecha-inicio-semana" name="fecha-inicio-semana" type="text" class="form-control bg-silver" readonly="readonly" value="<?= date('d/m/Y')?>" />    
                    </div>
                    <div class="form-group col-sm-6">
                        <label class="form-label">&nbsp;</label>
                        <input id="fecha-fin-semana" name="fecha-fin-semana" type="text" class="form-control bg-silver" readonly="readonly" value="<?= date('d/m/Y',$endweek)?>" />
                    </div>
                </div>
                <div id="fecha-abierta-group" class="row campos-filtro-citas">
                    <div class="form-group col-sm-6">
                        <label class="form-label">Fecha personalizada</label>
                        <input id="fecha-inicio-c" name="fecha-inicio-semana-c" type="text" class="form-control bg-silver" value="<?= date('d/m/Y',$_now)?>" />    
                    </div>
                    <div class="form-group col-sm-6">
                        <label class="form-label">&nbsp;</label>
                        <input id="fecha-fin-c" name="fecha-fin-semana-c" type="text" class="form-control bg-silver" value="<?= date('d/m/Y',$endweek)?>" />
                    </div>
                </div>
                <div class="row">
                    <div class="form-group col-sm-12">
                        <label class="control-label" for="estadoCita">Estado</label>
                        <?= Html::dropDownList('estado', '', Cita::$estados, [ 'class' => 'form-control', 'id' =>'estadoCita']) ?>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                <?= Html::submitButton('Exportar', ['id'=>'reportbtn', 'class' => 'btn btn-success']) ?>
                <?php ActiveForm::end(); ?>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<?=$this->render('../modals/cita/cancelar-cita-periodica')?>