<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use app\assets\CitaAsset;
use yii\helpers\ArrayHelper;
use app\models\Usuario;
use app\models\HorarioMedico;
use app\models\Cita;
use app\models\Suscripcion;
use app\customs\CitaPeriodica;

/* @var $this yii\web\View */
/* @var $model app\models\Cita */
/* @var $form yii\widgets\ActiveForm */
/* @var $usuario app\models\Usuario */
/* @var $suscripcion app\models\Suscripcion */
/* @var $schedule app\models\HorarioMedico */

$disabled = $model->estado == Cita::COMPLETADA ? true : false;
CitaAsset::register($this);
$nombrePaciente = $model->isNewRecord ? ((isset($paciente) && !$paciente->isNewRecord) ? $paciente->nombreCompleto : '') : $model->paciente->nombreCompleto;
$clasePaciente = ($model->isNewRecord ? (empty($nombrePaciente) ? '' : ' cuadro-lleno') : " cuadro-lleno");
$procedimientosModel = $model->isNewRecord ? [] : $model->procedimientoCitas;
$usuario = Yii::$app->user->identity;
$suscripcion = $usuario->suscripcion;
$idsProcedimientosModel = [];
foreach ($procedimientosModel as $procedimiento) {
    array_push($idsProcedimientosModel, $procedimiento->id_procedimiento);
}
if (!empty($idsProcCalendario)) {
    foreach ($idsProcCalendario as $procedimiento) {
        array_push($idsProcedimientosModel, $procedimiento);
    }
}
$today = \date('Y-m-d H:i:s');
$fecha = new DateTime($today);
$endMonth = (new DateTime($fecha->format('Y-m') . '-01'))->add(new DateInterval('P1M'))->sub(new DateInterval('P1D'));
?>
<script type="text/javascript">
    var id_cita = <?= !$model->isNewRecord ? $model->id  : 'undefined' ?>;
    var vistaCita = '<?= ($model->isNewRecord ? "create" : "update") ?>';
    var tU = '<?= $usuario->tipo ?>';
    var tSuscripcion = '<?= $suscripcion->tipo ?>';
    var todayDate = '<?= $today ?>';
    var modelDate = '<?= $model->isNewRecord ? $today : $model->fechaDB ?>';
    var endMonth = '<?= $endMonth->format('Y-m-d 23:59') ?>';
    var horaCita = '<?= $hora != null ? $hora : '' ?>';
    var fechaCita = '<?= $fechaStr != null ? $fechaStr : '' ?>';
    var setFechaCalendar = '<?= $fechaStr != null ? \DateTime::createFromFormat('d/m/Y', $fechaStr)->format('Y-m-d') : '' ?>';
    var horarios = '<?php
                    $horarios = HorarioMedico::find()->where(['id_suscripcion' => $usuario->suscripcion->id])->all();
                    $count = count($horarios) - 1;
                    foreach ($horarios as $k => $horaio) {
                        if ($k == $count) {
                            echo $horaio->dia;
                        } else {
                            echo $horaio->dia . ',';
                        }
                    } ?>';
    var diasNoHabiles = [
        <?php
        foreach ($diasNoHabiles as $dia) {
            echo ($dia - 1) . ',';
        }
        ?>
    ];
</script>
<?php
$form = ActiveForm::begin(['options' => ['class' => 'kt-form', 'autocomplete' => 'off', 'id' => 'cita-form']]);
echo $form->field($model,'periodo')->hiddenInput()->label(false);
echo $form->field($model,'rango')->hiddenInput()->label(false);
echo $form->field($model,'repeticiones')->hiddenInput()->label(false);
echo $form->field($model,'diaSemanaRepeticion')->hiddenInput()->label(false);
echo $form->field($model,'fechaLimite')->hiddenInput()->label(false);
echo $form->field($model,'finalizarRepeticionPor')->hiddenInput()->label(false);
?>
<div class="cita-form kt-portlet__body">
    <?php if ($usuario->tipo == Usuario::DOCTOR && $suscripcion->tipo == app\models\Suscripcion::TIPO_INDIVIDUAL) { ?>
        <div class="row">
            <div class="col-lg-12">
                <?= $form->field($model, 'id_clinica')->dropDownList($clinicas, ['disabled' => $disabled]) ?>
            </div>
        </div>
    <?php } ?>
    <?php if ($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA) { ?>

        <?= $form->field($model, 'id_clinica')->hiddenInput()->label(false) ?>
    <?php } ?>
    <div class="row">
        <div class="col-lg-5">
            <input name="costo-procedimiento" id="precio-por-procedimiento" type="text" readonly style="display: none;">
            <?php if ($suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL) { ?>
                <div class="form-group required">
                    <label class="control-label" for="pacienteAutocomplete">Procedimientos a Aplicar</label>
                    <select id="procedimientos" name="procedimientos[]" multiple="" class="form-control" <?= $disabled ? 'disabled' : '' ?>>
                        <?php
                        foreach ($procedimientos as $procedimiento) {
                            echo "<option value='$procedimiento->id' "
                                . (in_array($procedimiento->id, $idsProcedimientosModel) ? "selected='selected'" : "")
                                . " data-horas='$procedimiento->horas' "
                                . " data-costo='$procedimiento->costo' "
                                . " data-tipo='$procedimiento->tipo' "
                                . " data-minutos='$procedimiento->tiempo_duracion' "
                                . " data-clinica='" . join(",", ArrayHelper::getColumn($procedimiento->clinicaProcedimientos, 'id_clinica')) . "'>"
                                . " $procedimiento->nombre</option>";
                        }
                        ?>
                    </select>
                </div>
            <?php } ?>

            <?php if ($suscripcion->tipo == Suscripcion::TIPO_JERARQUIZADA) { ?>
                <div class="form-group required">
                    <label class="control-label" for="pacienteAutocomplete">Procedimientos a Aplicar</label>
                    <select id="procedimientos" name="procedimientos[]" multiple="" class="form-control" <?= $disabled ? 'disabled' : '' ?>>
                        <?php
                        foreach ($procedimientos as $procedimiento) {
                            echo "<option value='$procedimiento->id' "
                                . (in_array($procedimiento->id, $idsProcedimientosModel) ? "selected='selected'" : "")
                                . " data-horas='$procedimiento->horas' "
                                . " data-costo='$procedimiento->costo' "
                                . " data-minutos='$procedimiento->tiempo_duracion' >"
                                . " $procedimiento->nombre</option>";
                        }
                        ?>
                    </select>
                </div>
            <?php } ?>
        </div>
        <div class="col-lg-2">
            <div class="form-group">
                <label class="col-form-label">Tipo de Cita</label>
                <div class="radio-inline">
                    <label class="radio radio-success">
                    <input type="radio" name="tipo-cita" checked value="<?= Cita::CITA_PRESENCIAL ?>">
                    <span></span>Presencial</label>
                    <label class="radio radio-success ml-1">
                    <input type="radio" name="tipo-cita" value="<?= Cita::CITA_EN_LINEA ?>" <?= $model->tipo_cita == Cita::CITA_EN_LINEA ? 'checked' : '' ?>>
                    <span></span>En Linea</label>
                </div>
            </div>
        </div>
        <div class="col-lg-3">
            <?= $form->field($model, 'tiempo_estimado')->textInput(['disabled' => $disabled]) ?>
        </div>
        <div class="col-lg-2">
            <?= $form->field($model, 'costo')->textInput() ?>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-3">
            <div class="custom-control custom-switch mt-4">
                <input type="checkbox" class="custom-control-input" id="sobremontar">
                <label class="custom-control-label" for="sobremontar">Sobreponer Horario</label>
            </div>
        </div>
        <!-- <div class="col-lg-2">
            <? #= $form->field($model, 'fecha')->textInput(['autocomplete' => 'off', 'placeholder' => 'Fecha', 'onkeydown="return false;"', 'disabled'=>$disabled])
            ?>
        </div>-->
        <div class="col-lg-2">
            <?= $form->field($model, 'fecha')->textInput(['placeholder' => 'Fecha']) ?>
        </div>
        <div class="col-lg-2">
            <?= $form->field($model, 'hora')->dropDownList([], ['id' => 'horas', 'prompt' => 'Select'])->label('Hora <span style="color: red;"> *</span>') ?>
        </div>
        <div class="col-lg-4">
            <button type="button" data-toggle="modal" data-target="#cita-periodica-modal" class="btn btn-primary personalizadas-btn" id="btn-conf-modal" style="display: none;"><i class="fa fa-cogs p-2"></i></button>
            <?= $form->field($model, 'repetirCita')->dropDownList(CitaPeriodica::repeticionesMenu(), ['disabled'=>true]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-6 required">
            <label class="control-label" for="pacienteAutocomplete">Paciente</label>
            <?= Html::textInput('pacienteAutocomplete', $nombrePaciente, ['id' => 'pacienteAutocomplete', 'class' => 'form-control' . $clasePaciente, 'disabled' => $disabled]) ?>
            <?= $form->field($model, 'id_paciente')->hiddenInput()->label(false) ?>
        </div>
        <?php if ($actionName == 'create') : ?>
            <div class="col-lg-2">
                <a class="btn btn-success my-4 mb-2" href="#" data-toggle="modal" data-target="#_formModal">Crear Paciente</a>
            </div>
        <?php endif; ?>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <?= $form->field($model, 'asunto')->textarea(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <?= $form->field($model, 'diagnostico')->textarea(['maxlength' => true]) ?>
        </div>
    </div>
</div>
<div class="kt-portlet__foot">
    <div class="form-group kt-form__actions">
        <?= Html::submitButton('Guardar', ['class' => 'btn btn-success', 'id' => 'crear-cita']) ?>
    </div>
</div>
<?php ActiveForm::end(); ?>

<?= $this->render(
    '../modals/cita/acciones-de-cita',
    [
        'actionName' => $actionName,
        'model' => $modelP,
        'valoresComunicacion' => $valoresComunicacion,
        'valoresCamposRequeridos' => $valoresCamposRequeridos
    ]
) ?>
<?= $this->render('../modals/cita/cita-periodica') ?>