<?php

use yii\helpers\Html;
use app\assets\CalendarioAsset;

/* @var $this yii\web\View */

CalendarioAsset::register($this);

$this->title = 'Calendario Médico';
$this->params['breadcrumbs'][] = $this->title;
?>
<style type="text/css">
.fc-unthemed .fc-axis > span {
    font-size: 0.9rem;
    
}

.fc-time-grid .fc-slats td {
    height: 3.5em;
    border-bottom: 0;
}


.fc-event-container>a{
    padding: 1px;
}


.fc-unthemed .fc-event .fc-content, .fc-unthemed .fc-event-dot .fc-content {
    padding: 0.55rem 0.55rem 0.55rem 2rem;
}

.fc-unthemed .fc-event.fc-start.fc-event-solid-primary
{
	width:125px;
	margin-top: -7px;
	margin-left: -7px;

}

/* Tooltip container */
.tooltip {
  position: relative;
  display: inline-block;
  border-bottom: 1px dotted black; /* If you want dots under the hoverable text */
}

/* Tooltip text */
.tooltip .tooltiptext {
  visibility: hidden;
  width: 120px;
  background-color: black;
  color: #fff;
  text-align: center;
  padding: 5px 0;
  border-radius: 6px;
 
  /* Position the tooltip text - see examples below! */
  position: absolute;
  z-index: 1;
}

/* Show the tooltip text when you mouse over the tooltip container */
.tooltip:hover .tooltiptext {
  visibility: visible;
}

.form-group > span {
    box-sizing: border-box !important;
    display: block !important;
    margin: 0 !important;
    position: relative !important;
    vertical-align: middle !important; 
}

.select2-search > .select2-search__field{
    width: 270px !important;
}

.scrollarea-content{
  min-height:105%;
}


 .select2-selection--single .select2-selection__rendered {
    position: relative;
    padding: 3px !important;
}

.select2-container--default .select2-selection--single .select2-selection__arrow{
    height: 26px !important;
    position: absolute !important;
    top: 15px !important;
    right: 1px !important;
    width: 20px ;
}

.select2-container .select2-selection--single {
    box-sizing: border-box !important;
    cursor: pointer !important;
    display: block !important;
    height: 35px !important;
/*    user-select: none !important;*/
    -webkit-user-select: none !important;
}

</style>
<div class="horario-medico-index kt-portlet" id="calendario">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
        <div>
            <button id="ls-espera" data-toggle="modal" data-target="#ls-espera-modal" class="btn btn-success btn-sm mt-4" >Lista de Espera <span id="label-ls-es" class="badge badge-pill badge-danger">0</span></button>
            <button data-toggle="modal" data-target="#solicitudes-cita-modal" class="btn btn-primary btn-sm mt-4" >Solicitud de Citas <span id="label-num-sl" class="badge badge-pill badge-danger">0</span></button>
            <p class="text-rigth">
                <div class="checkbox-inline">
                    <label class="checkbox">
                    <input type="checkbox" class="calendario-field" id="olivia-field" checked="">
                    <span></span>Agenda</label>
                    <label class="checkbox">
                    <input type="checkbox" class="calendario-field" id="web-field">
                    <span></span>Solicitudes de cita</label>
                </div>
            </p>
        </div>
    </div>
    <div class="kt-portlet__body">
        <div id="calendario-medico"></div>
    </div>

</div>
<div id="_procsCita" class="modal fade">
    <div class="modal-dialog modal-dialog-centered modal-md">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Procedimientos</h4>
                <button class="close" data-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="_segBody">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="form-group required">
                            <label class="control-label" for="pacienteAutocomplete">Procedimientos a Aplicar</label>
                            <select id="procedimientos" name="procedimientos[]" multiple="" class="form-control">
                                <?php
                                foreach ($procedimientos as $procedimiento) {
                                    echo "<option value='$procedimiento->id'>"
                                    ." $procedimiento->nombre</option>";
                                }
                                ?>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-success" id="continuar">Continuar</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<div id="ls-espera-modal" class="modal fade">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Lista de Espera</h4>
                <button class="close" data-dismiss="modal" aria-label="Close"></button>
            </div>  
            <div class="modal-body">
                <div class="kt-scroll" data-scroll="true" data-mobile-height="300" data-height="400" style="overflow-y: scroll; height: 400px;">
                    <div class="scrollarea-content" id="items-lista">

                    </div>
                </div>                
            </div>    
    
            <div class="modal-footer">
                <button id="nueva-record" data-toggle="modal" data-target="#agregar-form" class="btn btn-success btn-sm">Añadir Paciente</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<div id="agregar-form" class="modal fade">
    <div class="modal-dialog modal-dialog-centered modal-md">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Añadir Paciente a Lista de Espera</h4>
                <button class="close" data-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form>
                    <div class="form-group">
                      <label for="id_paciente">Paciente</label>
                      <select type="email" class="form-control" id="id_paciente"></select>
                    </div>
                    <div class="form-group">
                      <label for="comentario">Disponibilidad del Paciente</label>
                      <textarea type="text" class="form-control" id="comentario" rows="5"></textarea>
                    </div>
                  </form>
            </div>
            <div class="modal-footer">
                <button id="guradar-lista" class="btn btn-success btn-sm">Guardar</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<?= $this->render('../modals/modals-solicitud-cita.php')?>