<?php

use yii\helpers\Html;
use yii\grid\GridView;
use app\assets\AsistentesAsset;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Asistentes';
$this->params['breadcrumbs'][] = $this->title;
AsistentesAsset::register($this);
?>
<div class="usuario-index kt-portlet">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
        <p class="d-none d-md-block mt-3">
            <?= Html::a('Crear Usuario', ['create'], ['class' => 'btn btn-success']) ?>
            <?= Html::a('Asociar asistente', '#', ['class' => 'asociar-asistente btn btn-primary']) ?>
        </p>
        <div class="d-md-none mt-2">
            <div class="btn-group">
                <button type="button" class="btn btn-secondary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="margin-left: 0 !important;">
                    Opciones
                </button>
                <div class="dropdown-menu dropdown-menu-right">
                    <?= Html::a('<i class="la la-user-plus kt-font-success mt-2"></i>Crear Usuario', ['create'], ['class' => 'dropdown-item']) ?>
                    <div class="dropdown-divider"></div>
                    <?= Html::a('<i class="la la-exchange kt-font-primary mt-2"></i>Asociar asistente', '#', ['class' => 'asociar-asistente dropdown-item']) ?>
                </div> 
            </div>
        </div>
    </div>
    <div class="kt-portlet__body">
        <div class="table-responsive">

               <?= GridView::widget([
                'dataProvider' => $dataProvider,
                'tableOptions' => ['class' => 'table table-hover','style'=>'font-size: 11pt'],
                'summary' => 'Mostrando {begin} - {end} de {totalCount} ítems',
                'rowOptions'=>function($model){
                   return ['data-id'=>$model->id];
                },
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],

                    'usuario.nombre_usuario',
                    'nombreClinica',
                    [
                        'label'=>'Activo',
                        'value' => function ($model){
                            return ($model->activo==1) ? 'Sí' : 'No';
                        }
                    ],

                    [
                        'class' => 'app\customs\ActionColumn',
                        'template' => '{view} {update} {delete} {activar}',
                        'buttons' => [
                            'delete' => function ($url,$model,$key){
                                return $model->usuario->getBitacoraCitas()->count() > 0
                                        ? ""
                                        : Html::a('<span class="kt-font-danger flaticon2-trash"></span>',
                                        ['delete', 'id' => $model->id],
                                        ['data-method' => 'post','data-confirm'=>'¿Está seguro de eliminar este elemento?']);
                            },
                            'activar' => function ($url,$model,$key){
                                return Html::a('<span class="kt-font-' . ($model->activo ? "danger" : "success") . ' ' . ($model->activo ? "flaticon2-cancel-music" : "flaticon2-check-mark" ) . '"></span>',
                                        ['activar', 'id' => $model->id],
                                        ['data-method' => 'post','data-confirm'=>'¿Está seguro de ' . ($model->activo ? 'inactivar' : 'activar') . ' al usuario?']);
                            },
                        ]
                    ],
                ],
            ]); ?>
            <?php
                $this->registerJs("
                    $('tbody td:not(.disable-click)').css('cursor', 'pointer');
                    $(document).on('click','table tr td:not(.disable-click)',function(e) {      
                        var id = $(this).closest('tr').data('id');
                        if (e.target == this && id)
                            location.href = '" . Url::to(['/asistente/view']) . "?id=' + id;
                    });
                ");
            ?>
        </div>
    </div>
</div>
<div id="dialog-buscar-asistente" class="modal fade" role="dialog">
    <div class="modal-dialog">
    <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Asociar asistente</h4>
                <button type="button" class="close" data-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="row-fluid">
                    <input id="correo-asistente" class="form-control" type="text" placeholder="Correo electrónico" />
                </div>
            </div>
            <div class="modal-footer">
                <button id="buscar-asistente" type="button" class="btn btn-primary" data-dismiss="modal">Buscar</button>
                <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>