<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel app\models\AccionSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Acciones';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="accion-index kt-portlet">
    <div class="kt-portlet__head">
        <div class="kt-portlet__head-label">
            <h1 class="kt-portlet__head-title"><?= Html::encode($this->title) ?></h1>
        </div>
    </div>
    <div class="kt-portlet__body">

                <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
    
            <?= GridView::widget([
            'dataProvider' => $dataProvider,
            'summary' => 'Mostrando {begin} - {end} de {totalCount} ítems',
            'filterModel' => $searchModel,
        'columns' => [
            
            'nombre',
            'nombre_amigable',
            'descripcion',
            [
                'attribute' => 'nombreControlador',
                'filter' => $controladores
            ],
            [
                'attribute'=>'tipo',
                'filter'=>[0 =>"General", 1=>"Suscripción"],
            ],

                [
                    'class' => 'app\customs\ActionColumn',
                    'template' => '{update} {view}'
                ],
            ],
        ]); ?>
    
    
    </div>
</div>
