<?php

namespace app\models\web;

use Yii;

/**
 * This is the model class for table "procedimiento_cita".
 *
 * @property int $id
 * @property int $id_cita
 * @property int $id_procedimiento
 * @property int $orden
 * @property int $costo
 * @property Cita $cita
 * @property Procedimiento $procedimiento
 */
class ProcedimientoCitaWeb extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'procedimiento_cita';
    }
    
    /**
     * @return \yii\db\Connection the database connection used by this AR class.
     */
    public static function getDB() {
        return Yii::$app->get('citaWebDB');
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_cita', 'id_procedimiento', 'costo'], 'required'],
            [['id_cita', 'id_procedimiento', 'orden'], 'integer'],
            [['costo'], 'number'],
            [['id_cita'], 'exist', 'skipOnError' => true, 'targetClass' => CitaWeb::className(), 'targetAttribute' => ['id_cita' => 'id']]
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'id_cita' => 'Id Cita',
            'id_procedimiento' => 'Id Procedimiento',
            'orden' => 'Orden',
            'costo' => 'Costo'
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCita()
    {
        return $this->hasOne(CitaWeb::className(), ['id' => 'id_cita']);
    }
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getProcedimiento()
    {
        return $this->hasOne(\app\models\Procedimiento::className(), ['id' => 'id_procedimiento']);
    }
}
