<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace app\models\repositories;

use yii\db\Expression;
use app\models\repositories\TokenRepository;
use app\models\UrlCita;
/**
 * Description of UrlCitaRepository
 *
 * @author jose.nieves
 */
class UrlCitaRepository {
    //put your code here
    
    /**
     * 
     * @param int $idCita
     * @return UrlCita
     */
    public static function obtenerUrlCitaPorCita($idCita){
        $maxTimeToken = \Yii::$app->params['maxTimeToken'];
        $urlCita = UrlCita::find()
                ->where(['id_cita' => $idCita])
                ->andWhere(['tipo' => UrlCita::PARA_CITA])
                ->andWhere(['>','fecha',new Expression('DATE_ADD(\'' . \date("Y-m-d H:i:s") . '\',INTERVAL -' . $maxTimeToken .' HOUR)')])
                ->one();
        if($urlCita == null){
            $urlCita = self::crearUrlCita($idCita,UrlCita::PARA_CITA);
        }
        return $urlCita;
    }
    
    /**
     * 
     * @param int $idCita
     * @return UrlCita
     */
    public static function crearUrlCita($idCita,$tipo){
        $token = TokenRepository::getToken(TokenRepository::TamanioToken);
        $llave = TokenRepository::getToken(TokenRepository::TamanioLlave);
        $urlCita = new UrlCita();
        $urlCita->id_cita = $idCita;
        $urlCita->token = $token;
        $urlCita->llave =$llave;
        $urlCita->tipo = $tipo;
        $urlCita->fecha = \date('Y-m-d H:i:s');
        $urlCita->save();
        return $urlCita;
    }
    
    public static function validarTokenUnico($token){
        
    }
    
    /**
     * 
     * @param string $token
     * @return UrlCita
     */
    public static function obtenerPorToken($token,$tipo){
        $tiempoMenor = \Yii::$app->params['maxTimeToken'];
        $query = UrlCita::find()->where(['token' => $token,'tipo' => $tipo]);
        $query->andWhere(['between',new Expression('\'' . \date("Y-m-d H:i:s")) . '\'','fecha',new Expression('DATE_ADD(fecha,INTERVAL ' . $tiempoMenor . ' HOUR)')]);
        return $query->one();
    }
    
    public static function eliminarUrlCitas($idCita,$tipo){
        UrlCita:: deleteAll(['id_cita' => $idCita,'tipo' => $tipo]);
    }
}
