<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace app\models\repositories;

/**
 * Description of TokenRepository
 *
 * @author jose.nieves
 */
class TokenRepository {
    //put your code here
    const CodeAlphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_";
    const CodeNums = '0123456789';
    const TamanioToken = 12;
    const TamanioLlave = 6;
    const TamanioPassword = 8;
    
    private static function crypto_rand_secure($min, $max)
    {
        $range = $max - $min;
        if ($range < 1) return $min; // not so random...
        $log = ceil(log($range, 2));
        $bytes = (int) ($log / 8) + 1; // length in bytes
        $bits = (int) $log + 1; // length in bits
        $filter = (int) (1 << $bits) - 1; // set all lower bits to 1
        do {
            $rnd = hexdec(bin2hex(openssl_random_pseudo_bytes($bytes)));
            $rnd = $rnd & $filter; // discard irrelevant bits
        } while ($rnd > $range);
        return $min + $rnd;
    }

    public static function getToken($length)
    {
        $token = "";
        
        $max = strlen(self::CodeAlphabet); // edited

        for ($i=0; $i < $length; $i++) {
            $token .= self::CodeAlphabet[self::crypto_rand_secure(0, $max-1)];
        }

        return $token;
    }
    
    public static function getTokenNums($length)
    {
        $token = "";
        $max = strlen(self::CodeNums); // edited
        for ($i=0; $i < $length; $i++) {
            $token .= self::CodeNums[self::crypto_rand_secure(0, $max-1)];
        }

        return $token;
    }
    
    
}
