<?php

namespace app\models\repositories;

use app\models\BitacoraPaciente;
use app\models\Suscripcion;
/**
 * Description of PacienteRepository
 *
 * @author jose.nieves
 */
class PacienteRepository {
   
    /**
     * Guarda una bitácora de paciente
     * @param int $idPaciente
     * @param int $estado
     * @param \app\models\Suscripcion $suscripcion
     * @param int $idGrupo
     * @param int $idUsuario
     */
    public static function GuardarBitacoraPaciente($idPaciente,$estado,$suscripcion,$idClinica,$idGrupo = null,$idUsuario = null){
        
        if($suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL) return;
        
        if($idUsuario == null){
            $idUsuario = \Yii::$app->user->id;
        }
        $bitacora = new BitacoraPaciente();
        $bitacora->id_paciente = $idPaciente;
        $bitacora->estado = $estado;
        $bitacora->fecha = date('Y-m-d H:i',  time());
        $bitacora->id_usuario = $idUsuario;
        $bitacora->id_clinica = $idClinica;
        $bitacora->id_grupo = $idGrupo;
        $bitacora->save();
    }
}
