<?php

namespace app\models\repositories;


use app\models\Clinica;
use app\models\Suscripcion;
use app\models\Usuario;
use app\models\UsuarioSuscripcion;
use app\models\GrupoTrabajoUsuario;

/**
 * Description of ClinicaRepository
 *
 * @author jose.nieves
 */
class ClinicaRepository {
    
    
    /**
     * 
     * @param Usuario $usuario
     * @param Suscripcion $suscripcion
     * @param bool $obtenerParaAsistentes
     * @return app\models\Clinica[]
     */
    public static function obtenerClinicasUsuario($usuario,$suscripcion,$obtenerParaAsistentes = true){
        $queryClinicas = Clinica::find()->where(['id_suscripcion' => $suscripcion->id]);
        $clinicas = [];
        if($suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL && $usuario->tipo == Usuario::DOCTOR){
            $clinicas = $queryClinicas->all();
        }
        else if($suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL && $usuario->tipo == Usuario::ASISTENTE){
            if($obtenerParaAsistentes){ $clinicas = $usuario->getClinicasActivasSuscripcion($suscripcion->id);}
        }
        else{
            $usuarioSuscripcion = UsuarioSuscripcion::findOne(['id_usuario' => $usuario->id,'activo' => true]);
            //Si es admin no posee un usuario suscripcion
            if($usuarioSuscripcion == null && $usuario->tipo == Usuario::DOCTOR){
                $clinicas = $queryClinicas->all();
            }
            else if($usuarioSuscripcion->tipo == UsuarioSuscripcion::TIPO_COORDINADOR || $usuarioSuscripcion::TIPO_ASISTENTE){
                $grupos = $usuario->getGruposTrabajoUsuario()->select('id_grupo')->column();
                $idsUsuarios = GrupoTrabajoUsuario::find()->where(['id_grupo' => $grupos])->select('id_usuario')->column();
                $idClinicas = UsuarioSuscripcion::find()->where(['id_usuario' => $idsUsuarios])->andWhere(['activo' => true])->select('id_clinica')->column();
                $clinicas = $queryClinicas->andWhere(['id' =>$idClinicas])->all();
            }else{
                $idClinica = UsuarioSuscripcion::findOne(['id_usuario' => $usuario->id,'activo' => true])->id_clinica;
                $clinicas = Clinica::find()->where(['id' => $idClinica])->all();
            }
        }
        return $clinicas;
    }
    
    
}
