<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace app\models\repositories;

use app\models\Cita;
use yii\db\Expression;
use app\models\BitacoraCita;
use app\models\Recordatorio;

/**
 * Description of CitaRepository
 *
 * @author jose.nieves
 */
class CitaRepository {
    //put your code here
    const EMAIL = 0;
    const SMS = 1;

    /**
     * Devuelve las citas con notificaciones para el momento, tomando 2:29 minutos antes y 2.29 minutos despues
     * @param int $tipoEnvio 0:EMAIL,1:SMS tomar del const de esta clase.
     * @return Cita[]
     */
    public static function citasNotificacion($tipoEnvio){
        $query = Cita::find()->alias('c')->select('c.*')
                ->join('INNER JOIN', 'recordatorio as r','r.id_suscripcion=c.id_suscripcion')
                ->where(['r.activo' => 1])
                ->andWhere(['>','c.fecha',new Expression('\''. \date("Y-m-d H:i:s") . '\'')]);
        $query->andWhere(
                    [
                        'between',
                        new Expression("(CASE r.unidad_tiempo WHEN 'HOUR' THEN DATE_ADD(c.fecha, INTERVAL -1 * r.tiempo_previo HOUR) WHEN 'DAY' THEN DATE_ADD(c.fecha, INTERVAL -1 * r.tiempo_previo DAY) ELSE DATE_ADD(c.fecha, INTERVAL -1 * r.tiempo_previo MINUTE) END)"),
                        new Expression('DATE_ADD(\'' . \date("Y-m-d H:i:s") . '\', INTERVAL -149 SECOND)'),
                        new Expression('DATE_ADD(\'' . \date("Y-m-d H:i:s") . '\', INTERVAL 149 SECOND)')
                    ]
                )
                ->andWhere([
                    'or',
                    ['c.estado' => 0],
                    ['c.estado' => 1],
                    ['c.estado' => 2],
                ]);
        $whereNotificacion = $tipoEnvio == self::EMAIL ? ['r.es_correo' => 1] : ['r.es_movil' => 1];
        $query->andWhere($whereNotificacion);
        //echo $query->createCommand()->rawSql;
        return $query->all();
    }
    
    /**
     * 
     * @param int $idSuscripcion
     * @param int $tipoEnvio
     * @return array
     */
    public static function recordatoriosCita($idSuscripcion,$tipoEnvio){
        $res = [];
        $query = Recordatorio::find()->alias('r')->select('r.*')
                ->join('INNER JOIN', 'cita as c', 'c.id_suscripcion=r.id_suscripcion')
                ->where(['r.id_suscripcion'=>$idSuscripcion])
                ->andWhere(['>','c.fecha',new Expression('\''. \date("Y-m-d H:i:s") . '\'')])
                ->andWhere(['r.activo'=>1]);
                $query->andWhere(
                    [
                        'between',
                        new Expression("(CASE r.unidad_tiempo WHEN 'HOUR' THEN DATE_ADD(c.fecha, INTERVAL -1 * r.tiempo_previo HOUR) WHEN 'DAY' THEN DATE_ADD(c.fecha, INTERVAL -1 * r.tiempo_previo DAY) ELSE DATE_ADD(c.fecha, INTERVAL -1 * r.tiempo_previo MINUTE) END)"),
                        new Expression('DATE_ADD(\'' . \date("Y-m-d H:i:s") . '\', INTERVAL -149 SECOND)'),
                        new Expression('DATE_ADD(\'' . \date("Y-m-d H:i:s") . '\', INTERVAL 149 SECOND)')
                    ]
                )
                ->andWhere([
                    'or',
                    ['c.estado' => 0],
                    ['c.estado' => 1],
                    ['c.estado' => 2],
                ]);
        $whereNotificacion = $tipoEnvio == self::EMAIL ? ['r.es_correo' => 1] : ['r.es_movil' => 1];
        $query->andWhere($whereNotificacion);
        foreach($query->all() as $recordatorio){
            $res[] = $recordatorio->nombre;
        }        
        return $res;
    }
    
    /**
     * 
     * @param int $idcita
     * @param int $estado
     * @param int $idUsuario
     */
    public static function GuardarBitacoraCita($idcita,$estado,$idUsuario){
        $bitacora = new BitacoraCita();
        $bitacora->id_cita = $idcita;
        $bitacora->estado = $estado;
        $bitacora->fecha = date('Y-m-d H:i',  time());
        $bitacora->id_usuario = $idUsuario;
        $bitacora->save();
    }
    /**
     * Eliminar registros duplicados de reprogramacion
     * @param int $idCita
     */
    public static function LimpiarBitacoraReprogramacion($idCita){
        BitacoraCita::deleteAll(['estado'=>1,'id_cita'=>$idCita]);
    }
}
