<?php

namespace app\models\cron;

use Yii;

/**
 * This is the model class for table "cron_log".
 *
 * @property int $id
 * @property string $cron_name
 * @property string $server_date
 * @property string $app_date
 * @property int $rows_count
 */
class CronLog extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'cron_log';
    }

    /**
     * @return \yii\db\Connection the database connection used by this AR class.
     */
    public static function getDb()
    {
        return Yii::$app->get('cronDB');
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['server_date', 'app_date'], 'safe'],
            [['rows_count'], 'integer'],
            [['cron_name'], 'string', 'max' => 150],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cron_name' => 'Cron Name',
            'server_date' => 'Server Date',
            'app_date' => 'App Date',
            'rows_count' => 'Rows Count',
        ];
    }
}
