<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "usuario_suscripcion".
 *
 * @property int $id
 * @property int $id_usuario
 * @property int $id_suscripcion
 * @property int $id_clinica
 * @property bool $activo
 * @property string $nombreClinica
 * @property int $tipo
 *
 * @property Clinica $clinica
 * @property Suscripcion $suscripcion
 * @property Usuario $usuario
 */
class UsuarioSuscripcion extends \yii\db\ActiveRecord
{
    
    // TIPIFICACIÓN UTILIZADA PARA LAS SUSCRIPCIONES JERARQUICAS.
    const TIPO_ASISTENTE = 0;
    const TIPO_DEPENDIENTE = 1;
    const TIPO_COORDINADOR = 2;
    const TIPO_ADMINISTRADOR = 4;
    
    public static $tipos = [0 => 'Asistente',1 => 'Terapeuta',2 => 'Coordinador', 4 => 'Administrador'];
    public static $tipoCoordinador = [0 => 'Asistente',1 => 'Terapeuta'];
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'usuario_suscripcion';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_usuario', 'id_suscripcion'], 'required'],
            [['id_usuario', 'id_suscripcion', 'tipo','id_clinica'], 'integer'],
            [['activo'], 'boolean'],
            [['id_clinica'], 'exist', 'skipOnError' => true, 'targetClass' => Clinica::className(), 'targetAttribute' => ['id_clinica' => 'id']],
            [['id_suscripcion'], 'exist', 'skipOnError' => true, 'targetClass' => Suscripcion::className(), 'targetAttribute' => ['id_suscripcion' => 'id']],
            [['id_usuario'], 'exist', 'skipOnError' => true, 'targetClass' => Usuario::className(), 'targetAttribute' => ['id_usuario' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'id_usuario' => 'Id Usuario',
            'id_suscripcion' => 'Id Suscripcion',
            'id_clinica' => 'Id Clinica',
            'activo' => 'Activo',
            'nombreClinica' => 'Clínica',
            'tipo' => 'Tipo'
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getClinica()
    {
        return $this->hasOne(Clinica::className(), ['id' => 'id_clinica']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSuscripcion()
    {
        return $this->hasOne(Suscripcion::className(), ['id' => 'id_suscripcion']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUsuario()
    {
        return $this->hasOne(Usuario::className(), ['id' => 'id_usuario']);
    }
    
    public function getNombreClinica(){
        return $this->id_clinica == null ? $this->usuario->perfil->nombreCorto : $this->clinica->nombre;
    }
    
     public function beforeDelete()
    {
        if (!parent::beforeDelete()) {
            return false;
        }
        if($this->usuario->getBitacoraCitas()->count() > 0){
            return false;
        }
        BitacoraMensajeLibre::deleteAll(['id_usuario' => $this->id_usuario]);
        Bitacora::deleteAll(['id_usuario' => $this->id_usuario]);
        return true;
    }
    
}
