<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "tipo_encargado".
 *
 * @property int $id
 * @property string $nombre
 *
 * @property Paciente[] $pacientes
 */
class TipoEncargado extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'tipo_encargado';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['nombre'], 'required','message'=>'El campo \'{attribute}\' no puede quedar vacío.'],
            [['nombre'], 'string', 'max' => 75],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'nombre' => 'Nombre',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPacientes()
    {
        return $this->hasMany(Paciente::className(), ['id_tipo_encargado' => 'id']);
    }
}
