<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "seguimiento".
 *
 * @property int $id
 * @property int $id_suscripcion
 * @property string $motivo
 * @property int $id_cita_origen
 * @property int $id_cita_destino
 * @property string $fecha_incidencia
 * @property int $id_paciente
 * @property int $estado
 * @property int $id_cita
 * @property string $fecha_cancelacion
 * @property string $fecha_seguimiento
 * @property string $hora_seguimiento
 * @property string $fecha_completado
 * @property string $interaccion
 * @property int $id_usuario
 * @property int $origen
 * @property string $fechaDB
 * @property Paciente $paciente
 * @property BitacoraSeguimiento[] $bitacoraSeguimiento
 * @property BitacoraSeguimiento $interaccionSeguimiento
 */
class Seguimiento extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    const PENDIENTE = 0;
    const COMPLETADO = 1;
    const PERDIDO = 2;
    public $hasFormat = false;
    
    public static function tableName()
    {
        return 'seguimiento';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_suscripcion', 'motivo', 'fecha_incidencia', 'id_paciente', 'fecha_seguimiento', 'hora_seguimiento', 'origen', 'interaccion'], 'required','message'=>'El campo \'{attribute}\' no puede quedar vacío.'],
            [['id_usuario', 'id_paciente', 'origen', 'id_suscripcion', 'estado', 'id_clinica'], 'integer'],
            [['id_cita_origen','id_cita_destino','fecha_completado', 'estado'], 'safe'],
            [['motivo'], 'string', 'max' => 500],
            [['id_usuario'], 'exist', 'skipOnError' => true, 'targetClass' => Usuario::className(), 'targetAttribute' => ['id_usuario' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'id_suscripcion' => 'Suscripcion',
            'id_usuario' => 'Usuario',
            'motivo' => 'Motivo',
            'id_cita_origen' => 'Cita de origen',
            'id_cita_destino' => 'Cita de destino',
            'fecha_incidencia' => 'Fecha de incidencia',
            'id_paciente' => 'Paciente',
            'interaccion'=>'Seguimiento',
            'estado' => 'Marcar como Completado',
            'fecha_seguimiento' => 'Fecha de seguimiento',
            'hora_seguimiento' => 'Hora de seguimiento',
            'fecha_completado' => 'Fecha Completado',
            'id_usuario' => 'ID usuario'
            
        ];
    }
    
    public function afterFind(){
        $fecha = $this->fecha_seguimiento;
        if(!is_null($fecha) && !empty($fecha)){
            $fecha_f = \DateTime::createFromFormat('Y-m-d', $fecha)->format('d/m/Y');
            $this->fecha_seguimiento = $fecha_f;
            $this->hasFormat = false;
        }
    }
    
    public function beforeSave($insert) {
        if(parent::beforeSave($insert)){
            if(!$this->hasFormat){
                $fecha = $this->fechaDB;
                $this->fecha_seguimiento = $fecha;
                $this->hasFormat = true;
            }
            return true;
        }
        return false;
    }

    public function getFechaDB(){
        if(!$this->hasFormat){
            return \DateTime::createFromFormat('d/m/Y', $this->fecha_seguimiento)->format('Y-m-d');
        }
        return $this->fecha_seguimiento;
    }
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPaciente()
    {
        return $this->hasOne(Paciente::className(), ['id' => 'id_paciente']);
    }
    
        /**
     * @return \yii\db\ActiveQuery
     */
    public function getBitacoraSeguimiento()
    {
        return $this->hasMany(BitacoraSeguimiento::className(), ['id_seguimiento' => 'id'])->orderBy(['fecha_incidencia'=> \SORT_DESC]);
    }
    
    public function getInteraccionSeguimiento(){
        return BitacoraSeguimiento::find()->where(['id_seguimiento'=>$this->id])->orderBy(['fecha_incidencia'=> \SORT_DESC])->limit(1)->one();
    }
    
}