<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "receta".
 *
 * @property int $id
 * @property int $id_suscripcion
 * @property int $id_paciente
 * @property string $receta
 * @property string $fecha_cita
 * @property string $proxima_cita
 * @property string $formatoReceta
 * @property Cita $paciente
 * @property string $fechaDB
 */
class Receta extends \yii\db\ActiveRecord
{
    public $hasFormat = false;
    
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'receta';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_suscripcion', 'id_paciente','receta', 'fecha_cita'], 'required'],
            [['id_suscripcion', 'id_paciente'], 'integer'],
            [['proxima_cita'], 'safe'],
            [['receta'], 'string', 'max' => 3000],
            [['id_paciente'], 'exist', 'skipOnError' => true, 'targetClass' => Paciente::className(), 'targetAttribute' => ['id_paciente' => 'id']]
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'id_suscripcion' => 'Id suscripción',
            'id_paciente' => 'Id Paciente',
            'receta' => 'Receta',
            'fecha_cita' => 'Fecha Cita',
            'proxima_cita' => 'Proxima Cita'
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPaciente()
    {
        return $this->hasOne(Paciente::className(), ['id' => 'id_paciente']);
    }
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getFormatoReceta()
    {
        return nl2br($this->receta);
    }
    
    
    public function beforeSave($insert) {
        if(parent::beforeSave($insert)){
            if(!$this->hasFormat){
                $fecha_cita = $this->fechaDB;
                $this->fecha_cita = $fecha_cita;
                if($this->proxima_cita != null){
                    $this->proxima_cita = \DateTime::createFromFormat('d/m/Y', $this->proxima_cita)->format('Y-m-d');
                }
                $this->hasFormat = true;
            }
            return true;
        }
        return false;
    }

    public function getFechaDB(){
        if(!$this->hasFormat){
            return \DateTime::createFromFormat('d/m/Y', $this->fecha_cita)->format('Y-m-d');
        }
        return $this->fecha_cita;
    }
    
    
    public function afterFind(){
        $fecha = $this->fecha_cita;
        if(!is_null($fecha) && !empty($fecha)){
            $fecha_f = \DateTime::createFromFormat('Y-m-d', $fecha)->format('d/m/Y');
            $this->fecha_cita = $fecha_f;
            $this->hasFormat = false;
        }
        $prox_cita = $this->proxima_cita;
        if(!is_null($prox_cita) && !empty($prox_cita)){
            $prox_cita_f = \DateTime::createFromFormat('Y-m-d', $prox_cita)->format('d/m/Y');
            $this->proxima_cita = $prox_cita_f;
            $this->hasFormat = false;
        }
    }
    
    

}
