<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "proveedor".
 *
 * @property int $id
 * @property string $nombre
 * @property string $nit
 * @property string $email
 * @property string $telefono_principal
 * @property string $telefono_secundario
 * @property string $direccion
 * @property int $id_suscripcion
 *
 * @property Producto[] $productos
 * @property Suscripcion $suscripcion
 */
class Proveedor extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'proveedor';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['nombre','id_suscripcion'], 'required'],
            [['nombre', 'nit', 'email'], 'string', 'max' => 250],
            [['id_suscripcion'],'integer'],
            [['nombre', 'nit'], 'string', 'max' => 250],
            [['telefono_principal', 'telefono_secundario'], 'string', 'max' => 15],
            [['direccion'], 'string', 'max' => 500],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'nombre' => 'Nombre',
            'nit' => 'Nit',
            'email' => 'Email',
            'telefono_principal' => 'Tel. Principal',
            'telefono_secundario' => 'Tel. Secundario',
            'direccion' => 'Dirección',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getProductos()
    {
        return $this->hasMany(Producto::className(), ['id_proveedor' => 'id']);
    }
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSuscripcion()
    {
        return $this->hasOne(Suscripcion::className(), ['id' => 'id_suscripcion']);
    }
}
