<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "procedimiento_cita".
 *
 * @property int $id
 * @property int $id_cita
 * @property int $id_procedimiento
 * @property int $orden
 * @property int $costo_editado
 * @property Cita $cita
 * @property Procedimiento $procedimiento
 */
class ProcedimientoCita extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'procedimiento_cita';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_cita', 'id_procedimiento', 'costo_editado'], 'required'],
            [['id_cita', 'id_procedimiento', 'orden'], 'integer'],
            [['costo_editado'], 'number'],
            [['id_cita'], 'exist', 'skipOnError' => true, 'targetClass' => Cita::className(), 'targetAttribute' => ['id_cita' => 'id']],
            [['id_procedimiento'], 'exist', 'skipOnError' => true, 'targetClass' => Procedimiento::className(), 'targetAttribute' => ['id_procedimiento' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'id_cita' => 'Id Cita',
            'id_procedimiento' => 'Id Procedimiento',
            'orden' => 'Orden',
            'costo_editado' => 'Costo Editado'
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCita()
    {
        return $this->hasOne(Cita::className(), ['id' => 'id_cita']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getProcedimiento()
    {
        return $this->hasOne(Procedimiento::className(), ['id' => 'id_procedimiento']);
    }
}
