<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "procedimiento".
 *
 * @property int $id
 * @property string $nombre
 * @property string $descripcion
 * @property string $costo
 * @property string $tiempo
 * @property int $tiempo_duracion
 * @property int $tiempo_recordatorio
 * @property int $id_suscripcion
 * @property int $tipo
 * @property bool $para_solicitud_cita
 * @property int $totalProcedimientoCitas
 *
 * @property Suscripcion $suscripcion
 * @property ClinicaProcedimiento[] $clinicaProcedimientos
 * @property ProcedimientoCita[] $procedimientoCitas
 * @property GrupoProcedimiento[] $gruposProcedimiento
 */
class Procedimiento extends \yii\db\ActiveRecord
{ 
    
    const PRESENCIAL = 0;
    const EN_LINEA = 1;
    
    const PARA_SOLICITUD_CITA = 1;
  
    public $horas;
    private $tiempo_consolidado = false;
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'procedimiento';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['nombre', 'costo', 'id_suscripcion'], 'required','message'=>'El campo \'{attribute}\' no puede quedar vacío.'],
            [['costo', 'tipo'], 'number'],
            [['tiempo_duracion', 'tiempo_recordatorio', 'id_suscripcion' ,'horas'], 'integer'],
            [['nombre'], 'string', 'max' => 150],
            [['horas'], 'safe'],
            [['para_solicitud_cita'], 'boolean'],
            [['descripcion'], 'string', 'max' => 400],
            [['id_suscripcion'], 'exist', 'skipOnError' => true, 'targetClass' => Suscripcion::className(), 'targetAttribute' => ['id_suscripcion' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'nombre' => 'Nombre',
            'descripcion' => 'Descripción',
            'costo' => 'Costo',
            'tiempo_duracion' => 'Tiempo de duración (minutos)',
            'horas' => 'Tiempo de Duración',
            'tiempo' => 'Tiempo de Duración',
            'para_solicitud_cita' => 'Posibilidad para paciente de solicitar desde link de agendamiento',
            'id_suscripcion' => 'Suscripcion',
        ];
    }
    
     public function beforeSave($insert) {
        if(parent::beforeSave($insert)){
            if(!$this->tiempo_consolidado){
                //$this->tiempo_duracion = ($this->horas * 60) + $this->tiempo_duracion;
                $this->tiempo_duracion = (($this->horas == null ? 0 : $this->horas) * 60) + ($this->tiempo_duracion == null ? 0 : $this->tiempo_duracion);
                $this->tiempo_consolidado = true;
            }
            return true;
        }
        return false;
    }
    
    public function afterFind(){
        $this->horas = intval($this->tiempo_duracion/60);
        $this->tiempo_duracion = $this->tiempo_duracion - ($this->horas * 60);
    }
    
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTiempo()
    {
        return ($this->horas == 0 ? '' : ($this->horas . ' hora' . ($this->horas == 1 ? '' : 's') . ', ')) . $this->tiempo_duracion . ' minutos';
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSuscripcion()
    {
        return $this->hasOne(Suscripcion::className(), ['id' => 'id_suscripcion']);
    } 
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getClinicaProcedimientos()
    {
        return $this->hasMany(ClinicaProcedimiento::className(), ['id_procedimiento' => 'id']);
    }
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getProcedimientoCitas()
    {
        return $this->hasMany(ProcedimientoCita::className(), ['id_procedimiento' => 'id']);
    }
    
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGruposProcedimiento()
    {
        return $this->hasMany(GrupoProcedimiento::className(), ['id_procedimiento' => 'id']);
    }
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTotalProcedimientoCitas()
    {
        return $this->getProcedimientoCitas()->count();
    }
    
    public function beforeDelete()
    {
        if($this->getProcedimientoCitas()->count() > 0){
            return false;
        }
        if($this->totalProcedimientoCitas < 1){
            $clinicaProcedimientos = $this->clinicaProcedimientos;
            foreach ($clinicaProcedimientos as $clinicaProc){
                $clinicaProc->delete();
            }
        }
        return parent::beforeDelete();
    }
    
    
    
    public function tiempoLleno($attribute,$params){
       if(($this->tiempo_duracion != null && $this->tiempo_duracion >0) || ($this->horas != null && $this->horas >0)){
           return true;
       }
       $this->addError($attribute, 'Debe agregar un tiempo al procedimiento');
       return false;
    }

}
