<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "plantilla_mensaje".
 *
 * @property int $id
 * @property string $nombre
 * @property int $id_suscripcion
 * @property string $cuerpo
 * @property int $id_usuario
 * @property bool $es_mail
 * @property bool $es_sms
 *
 * @property Suscripcion $suscripcion
 * @property Usuario $usuario
 */
class PlantillaMensaje extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'plantilla_mensaje';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_suscripcion', 'cuerpo', 'id_usuario'], 'required'],
            [['id_suscripcion', 'id_usuario'], 'integer'],
            [['es_mail', 'es_sms'], 'boolean'],
            [['nombre'], 'string', 'max' => 150],
            [['cuerpo'], 'string', 'max' => 1000],
            [['id_suscripcion'], 'exist', 'skipOnError' => true, 'targetClass' => Suscripcion::className(), 'targetAttribute' => ['id_suscripcion' => 'id']],
            [['id_usuario'], 'exist', 'skipOnError' => true, 'targetClass' => Usuario::className(), 'targetAttribute' => ['id_usuario' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'nombre' => 'Nombre',
            'id_suscripcion' => 'Id Suscripcion',
            'cuerpo' => 'Cuerpo',
            'id_usuario' => 'Id Usuario',
            'es_mail' => 'Es Mail',
            'es_sms' => 'Es Sms',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSuscripcion()
    {
        return $this->hasOne(Suscripcion::className(), ['id' => 'id_suscripcion']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUsuario()
    {
        return $this->hasOne(Usuario::className(), ['id' => 'id_usuario']);
    }
}
