<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "plantilla_historial".
 *
 * @property int $id
 * @property int $id_suscripcion
 * @property string $titulo
 * @property string $cuerpo
 * @property string $formatoCuerpo
 * @property Suscripcion $suscripcion
 * @property Usuario $usuario
 */
class PlantillaHistorial extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'plantilla_historial';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_suscripcion', 'titulo','cuerpo'], 'required'],
            [['id_suscripcion'], 'integer'],
            [['titulo'], 'string', 'max' => 200],
            [['id_suscripcion'], 'exist', 'skipOnError' => true, 'targetClass' => Suscripcion::className(), 'targetAttribute' => ['id_suscripcion' => 'id']]
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'id_suscripcion' => 'Id Suscripcion',
            'titulo' => 'Titulo',
            'cuerpo' => 'Cuerpo',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSuscripcion()
    {
        return $this->hasOne(Suscripcion::className(), ['id' => 'id_suscripcion']);
    }
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getFormatoCuerpo()
    {
        return nl2br($this->cuerpo);
    }

}
