<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "permiso_usuario".
 *
 * @property int $id
 * @property int $id_suscripcion
 * @property int $id_usuario
 * @property int $id_accion
 * @property int $permitido
 *
 * @property Accion $accion
 * @property Suscripcion $suscripcion
 * @property Usuario $usuario
 */
class PermisoUsuario extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'permiso_usuario';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_suscripcion', 'id_usuario', 'id_accion'], 'required'],
            [['id_suscripcion', 'id_usuario', 'id_accion', 'permitido'], 'integer'],
            [['id_accion'], 'exist', 'skipOnError' => true, 'targetClass' => Accion::className(), 'targetAttribute' => ['id_accion' => 'id']],
            [['id_suscripcion'], 'exist', 'skipOnError' => true, 'targetClass' => Suscripcion::className(), 'targetAttribute' => ['id_suscripcion' => 'id']],
            [['id_usuario'], 'exist', 'skipOnError' => true, 'targetClass' => Usuario::className(), 'targetAttribute' => ['id_usuario' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'id_suscripcion' => 'Id Suscripcion',
            'id_usuario' => 'Id Usuario',
            'id_accion' => 'Id Accion',
            'permitido' => 'Permitido',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAccion()
    {
        return $this->hasOne(Accion::className(), ['id' => 'id_accion']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSuscripcion()
    {
        return $this->hasOne(Suscripcion::className(), ['id' => 'id_suscripcion']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUsuario()
    {
        return $this->hasOne(Usuario::className(), ['id' => 'id_usuario']);
    }
}
