<?php

namespace app\models;

use Yii;
use app\customs\Utils;

/**
 * This is the model class for table "perfil".
 *
 * @property int $id
 * @property string $nombre
 * @property string $apellidos
 * @property string $email
 * @property string $telefonos
 * @property string $foto_perfil
 * @property string $nombreCompleto
 * @property string $nombreCorto
 * @property string $primerApellido
 * @property string $primerNombre
 *
 * @property Usuario $usuario
 */
class Perfil extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'perfil';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'nombre', 'apellidos', 'email', 'telefonos'], 'required','message'=>'El campo \'{attribute}\' no puede quedar vacío.'],
            [['id'], 'integer'],
            [['nombre', 'apellidos'], 'string', 'max' => 200],
            [['email', 'telefonos'], 'string', 'max' => 150],
            [['foto_perfil'], 'string', 'max' => 300],
            [['id'], 'unique'],
            [['email'],'email','message' => 'El correo ingresado no es válido.'],
            [['id'], 'exist', 'skipOnError' => true, 'targetClass' => Usuario::className(), 'targetAttribute' => ['id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'nombre' => 'Nombre',
            'apellidos' => 'Apellidos',
            'email' => 'Email',
            'telefonos' => 'Telefonos',
            'foto_perfil' => 'Foto Perfil',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUsuario()
    {
        return $this->hasOne(Usuario::className(), ['id' => 'id']);
    }
    
    /**
     * @return string
     */
    public function getNombreCompleto()
    {
        return $this->nombre . ' ' . $this->apellidos;
    }
    
    /**
     * @return string
     */
    public function getNombreCorto()
    {
        return Utils::shortName($this->nombre,$this->apellidos);
    }
    
    /**
     * @return string
     */
    public function getPrimerApellido()
    {
        return Utils::firstPartName($this->apellidos);
    }
    
    /**
     * @return string
     */
    public function getPrimerNombre()
    {
        return Utils::firstPartName($this->nombre);
    }

}
