<?php

namespace app\models;

use Yii;
use yii\helpers\Url;
/**
 * This is the model class for table "notificacion".
 *
 * @property int $id
 * @property string $titulo
 * @property string $descripcion
 * @property string $verbo
 * @property string $accion
 * @property bool $activo
 * @property bool $es_privado
 * @property int $tipo
 * @property string $tipoNotificacion
 * @property string $accionNotificacion
 * @property string $descripcionNotificacion
 */
class Notificacion extends \yii\db\ActiveRecord
{
    const NUEVO = 0;
    const CAMBIO = 1;
    const AJUSTE = 2; 
    const AVISO = 3;


    
    const TIPOS = ['Nuevo', 'Cambio', 'Ajuste', 'Aviso'];
    
    public $hasFormat = false;
    
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'notificacion';
    }
    
    /**
     * {@inheritdoc}
     */
    public function rules(){
        return [
            [['titulo', 'descripcion', 'tipo'], 'required','message'=>'El campo \'{attribute}\' no puede quedar vacío.'],
            [['titulo'],'string', 'max' => 200],
            [['descripcion'],'string', 'max' => 3000],
            [['accion'],'string', 'max' => 100],
            [['verbo'],'string', 'max' => 50],
            [['verbo', 'accion'],'safe'],
            [['activo', 'es_privado'],'boolean']
        ];
    }
    
    /**
     * {@inheritdoc}
     */
    public function attributeLabels(){
        return [
            'id'=>'ID',
            'titulo'=>'Título',
            'descripcion'=>'Descripción',
            'accion'=>'Acción',
            'verbo'=>'Verbo',
            'activo'=>'Activo',
            'tipo'=>'Tipo',
            'es_privado'=>'¿Es privado?'
        ];
    }
       
    public function getTipoNotificacion()
    {
        $val = '';
        switch ($this->tipo){
            case Notificacion::NUEVO:
                $val = "Nuevo";
                break;
            case Notificacion::CAMBIO:
                $val = "Cambio";
                break;
            case Notificacion::AJUSTE:
                $val = "Ajuste";
                break;
            case Notificacion::AVISO:
                $val = "Aviso";
                break;
        }
        return $val;
    }
    
    public function getAccionNotificacion(){
        (string)$accion = $this->accion; 
        if($accion  != null){
            if(preg_match('/[a-z]\/[a-z-]/',$accion ) && !preg_match('/https:\/\/[\w]/i', $accion)){
                return Url::toRoute([$accion]);
            } else {
                if(preg_match('/https:\/\/[\w]/i', $accion)){
                    return $accion;
                } else {
                    return "https://".$accion;
                }
            }
        }
        return 'No definido';
    }
    
    public function getDescripcionNotificacion(){
        return nl2br($this->descripcion);
    }
    
}
