<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "lista_espera".
 *
 * @property int $id
 * @property int $id_suscripcion
 * @property int $id_paciente
 * @property string $comentario
 * @property string $fecha_creacion
 * @property int $estado
 * @property Paciente $paciente
 * @property Suscripcion $suscripcion
 */
class ListaEspera extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    const PENDIENTE = 0;
    const COMPLETADO = 1;
    
    public $hasFormat = false;
    
    public static function tableName()
    {
        return 'lista_espera';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_suscripcion', 'fecha_creacion', 'id_paciente','estado'], 'required','message'=>'El campo \'{attribute}\' no puede quedar vacío.'],
            [['id_paciente', 'id_suscripcion', 'estado'], 'integer'],
            [['comentario'], 'string', 'max' => 500],
            [['id_suscripcion'], 'exist', 'skipOnError' => true, 'targetClass' => Suscripcion::className(), 'targetAttribute' => ['id_suscripcion' => 'id']],
            [['id_paciente'], 'exist', 'skipOnError' => true, 'targetClass' => Paciente::className(), 'targetAttribute' => ['id_paciente' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'id_suscripcion' => 'Suscripcion',
            'id_paciente' => 'Paciente',
            'comentario' => 'Comentario',
            'fecha_creacion' => 'Fecha de creación',
            'estado' => 'Estado'
            
        ];
    }
    
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPaciente()
    {
        return $this->hasOne(Paciente::className(), ['id' => 'id_paciente']);
    }
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSuscripcion()
    {
        return $this->hasOne(Suscripcion::className(), ['id' => 'id_suscripcion']);
    }
   
    
}