<?php

namespace app\models;
use Stripe\Customer;
use Stripe\Subscription;
use Stripe\Invoice;

use Yii;

/**
 * This is the model class for table "forma_pago".
 *
 * @property int $id
 * @property string $customer_id
 * @property string $created
 * @property string $currency
 * @property string $invoice_prefix
 * @property string $description
 * @property string $pay_method
 * @property string $subcription_id
 * @property string $nombreUsuario
 *
 * @property Perfil $perfil
 * @property Usuario $usuario
 * @property \Stripe\Subscription $stripeSuscription
 * @property \Stripe\Customer $stripeCustomer
 * @property \Stripe\Invoice[] $invoices
 */
class FormaPago extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'forma_pago';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'customer_id'], 'required'],
            [['id'], 'integer'],
            [['created'], 'safe'],
            [['customer_id','pay_method','subcription_id'], 'string', 'max' => 75],
            [['currency'], 'string', 'max' => 10],
            [['invoice_prefix'], 'string', 'max' => 50],
            [['description'], 'string', 'max' => 500],
            [['id'], 'unique'],
            [['id'], 'exist', 'skipOnError' => true, 'targetClass' => Perfil::className(), 'targetAttribute' => ['id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'customer_id' => 'Customer ID',
            'pay_method' => 'Pay method',
            'subcription_id' => 'Subcription ID',
            'created' => 'Created',
            'currency' => 'Currency',
            'invoice_prefix' => 'Invoice Prefix',
            'description' => 'Description',
            'nombreUsuario' => 'Usuario',
        ];
    }
    
    public function getStripeSuscription(){
  
        try {
            $subscription = Subscription::retrieve(
                    $this->subcription_id
            );
            return $subscription;
        }
        catch (\Exception $ex){
            return $ex->getMessage();
        }
        
    }
    
    public function getStripeCustomer(){
        try {
            $customer = Customer::retrieve(
                    $this->customer_id
            );
            return $customer;
        }
        catch (\Exception $ex){
            return $ex->getMessage();
        }
        
    }
    
    public function getStripeInvoices($limit){
        try {
            return Invoice::all(['limit' => $limit,'customer' => $this->customer_id]);
        }
        catch (\Exception $ex){
            return $ex->getMessage();
        }
        
    }
     
    /**
     * 
     * @return string
     */
    public function getNombreUsuario(){
        return $this->usuario->nombre_usuario;
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUsuario()
    {
        return $this->hasOne(Usuario::className(), ['id' => 'id']);
    }
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPerfil()
    {
        return $this->hasOne(Perfil::className(), ['id' => 'id']);
    }
}
