<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "factura".
 *
 * @property int $id
 * @property string $fecha_inicio
 * @property string $fecha_fin
 * @property int $total_citas
 * @property string $costo_cita
 * @property string $costo_base
 * @property string $fecha_emision
 * @property int $id_suscripcion
 * @property int $estado
 *
 * @property Suscripcion $suscripcion
 */
class Factura extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'factura';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['fecha_inicio', 'fecha_fin', 'total_citas', 'costo_cita', 'costo_base', 'fecha_emision', 'id_suscripcion', 'estado'], 'required'],
            [['fecha_inicio', 'fecha_fin', 'fecha_emision'], 'safe'],
            [['total_citas', 'id_suscripcion', 'estado'], 'integer'],
            [['costo_cita', 'costo_base'], 'number'],
            [['id_suscripcion'], 'exist', 'skipOnError' => true, 'targetClass' => Suscripcion::className(), 'targetAttribute' => ['id_suscripcion' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'fecha_inicio' => 'Fecha Inicio',
            'fecha_fin' => 'Fecha Fin',
            'total_citas' => 'Total Citas',
            'costo_cita' => 'Costo Cita',
            'costo_base' => 'Costo Base',
            'fecha_emision' => 'Fecha Emision',
            'id_suscripcion' => 'Id Suscripcion',
            'estado' => 'Estado',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSuscripcion()
    {
        return $this->hasOne(Suscripcion::className(), ['id' => 'id_suscripcion']);
    }
}
