<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "cupon_suscripcion".
 *
 * @property int $id
 * @property int $id_suscripcion
 * @property int $id_cupon
 * @property Suscripcion $suscripcion
 * @property Cupon $cupon
 */
class CuponSuscripcion extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    
    
    public static function tableName()
    {
        return 'cupon_suscripcion';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_suscripcion', 'id_cupon'], 'required','message'=>'El campo \'{attribute}\' no puede quedar vacío.'],
            [['id_suscripcion', 'id_cupon'], 'integer'],
            [['id_suscripcion'], 'exist', 'skipOnError' => true, 'targetClass' => Suscripcion::className(), 'targetAttribute' => ['id_suscripcion' => 'id']],            
            [['id_cupon'], 'exist', 'skipOnError' => true, 'targetClass' => Cupon::className(), 'targetAttribute' => ['id_cupon' => 'id']],

        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'id_suscripcion' => 'ID suscripcion',
            'id_cupon' => 'ID cupon'
            
        ];
    }
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSuscripcion()
    {
        return $this->hasOne(Suscripcion::className(), ['id_suscripcion' => 'id']);
    }
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCupon()
    {
        return $this->hasOne(Cupon::className(), ['id' => 'id_cupon']);
    }
    
}