<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "cupon".
 *
 * @property int $id
 * @property string $nombre
 * @property string $terminos
 * @property string $stripe_id
 * @property bool $activo
 *
 */
class Cupon extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'cupon';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['nombre','terminos','stripe_id'], 'required','message'=>'El campo \'{attribute}\' no puede quedar vacío.'],
            [['activo'], 'boolean'],
            [['nombre', 'terminos'], 'string', 'max' => 150],
            [['stripe_id'], 'string', 'max' => 75],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'Id',
            'nombre' => 'Nombre',
            'terminos' => 'Terminos',
            'activo' => 'Activo',
            'stripe_id' => 'Stripe ID',
        ];
    }

}
