<?php

namespace app\models;

use Yii;
use app\models\repositories\ControladoresQuery;

/**
 * This is the model class for table "controlador".
 *
 * @property int $id
 * @property string $nombre
 * @property string $nombre_amigable
 * @property string $descripcion
 *
 * @property Accion[] $accions
 */
class Controlador extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'controlador';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['nombre', 'nombre_amigable', 'descripcion'], 'required'],
            [['nombre'], 'string', 'max' => 75],
            [['nombre_amigable'], 'string', 'max' => 150],
            [['descripcion'], 'string', 'max' => 250],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'nombre' => 'Nombre',
            'nombre_amigable' => 'Nombre Amigable',
            'descripcion' => 'Descripcion',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAcciones()
    {
        return $this->hasMany(Accion::className(), ['id_controlador' => 'id']);
    }
    
    public function getPermisionCount($idRol){
        $total=ControladoresQuery::getActionPermisions($this->id,$idRol);
        return $total;
    }
    
    public function getPermisionCountUsuario($idController, $idUsuario, $idSuscripcion){
        $total=ControladoresQuery::getActionPermisionsUsuario($idController, $idUsuario, $idSuscripcion);
        return $total;
    }
}
