<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "configuracion_suscripcion".
 *
 * @property int $id
 * @property int $id_suscripcion
 * @property string $nombre
 * @property string $llave
 * @property string $valor
 * @property int $tipo
 * @property string $descripcion
 * @property string $posibles_valores
 * @property bool $visible
 * @property int $orden
 * @property int $id_clinica
 * @property Suscripcion $suscripcion
 * @property Clinica $clinica
 */
class ConfiguracionSuscripcion extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'configuracion_suscripcion';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_suscripcion', 'nombre', 'llave'], 'required'],
            [['id_suscripcion', 'tipo','id_clinica'], 'integer'],
            [['visible'], 'boolean'],
            [['nombre'], 'string', 'max' => 150],
            [['llave'], 'string', 'max' => 50],
            [['valor', 'descripcion'], 'string', 'max' => 400],
            [['posibles_valores'], 'string', 'max' => 600],
            [['id_suscripcion'], 'exist', 'skipOnError' => true, 'targetClass' => Suscripcion::className(), 'targetAttribute' => ['id_suscripcion' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'id_suscripcion' => 'Id Suscripcion',
            'nombre' => 'Nombre',
            'llave' => 'Llave',
            'valor' => 'Valor',
            'tipo' => 'Tipo',
            'descripcion' => 'Descripcion',
            'posibles_valores' => 'Posibles Valores',
            'visible' => 'Visible',
            'orden' => 'Orden',
            'id_clinica' => 'Clinica'
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSuscripcion()
    {
        return $this->hasOne(Suscripcion::className(), ['id' => 'id_suscripcion']);
    }
    
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getClinica()
    {
        return $this->hasOne(Clinica::className(), ['id' => 'id_clinica']);
    }
}
