<?php
namespace app\models;

use Yii;
/**
 * This is the model class for table "comentario_suscripcion".
 *
 * @property int $id
 * @property int $id_suscripcion
 * @property string $comentario
 * @property string $fecha
 * @property Suscripcion $suscripcion  
 *
 */
class ComentarioSuscripcion extends \yii\db\ActiveRecord {
    
    public static function tableName() {
        return 'comentario_suscripcion';
    }
    
    public function rules(){
        return [
            [['id_suscripcion', 'comentario', 'fecha'], 'required', 'message'=>'El campo \'{attribute}\' no puede quedar vacío.'],
            [['id_suscripcion'], 'integer'],
            [['comentario'], 'string'],
            [['comentario'], 'string', 'max' => 800],
            [['id_suscripcion'], 'exist', 'skipOnError' => true, 'targetClass' => Suscripcion::className(), 'targetAttribute' => ['id_suscripcion' => 'id']],
        ];
    }
    
    public function attributeLabels() {
        return [
            'id' => 'ID',
            'id_suscripcion' => 'ID Suscripcion',
            'comentario' => 'Comentario',
            'fecha' => 'Fecha'
        ];
    }
    
    public function getSuscripcion(){
        return $this->hasOne(Suscripcion::className(), ['id' => 'id_suscripcion']);
    }
}

