<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "cobro_pagadito".
 *
 * @property int $id
 * @property int $id_cita
 * @property string $n_factura
 * @property float $total_cita
 * @property float $cargo_pasarela
 * @property int $cargar_iva
 * @property float $iva
 * @property float $total_cobrado
 * @property int $metodo_cobro
 * @property string $notas
 * @property string $fecha_cobro
 * @property string $fecha_pago
 * @property string $estado
 * @property string $token
 * @property int $tipo
 * @property string $urlCobro
 * @property string $textoEstado
 * @property Cita $cita
 */
class CobroPagadito extends \yii\db\ActiveRecord 
{
    const ASUMIR_CARGO_PASARELA = 0;
    const CARGO_PASARELA_PACIENTE = 1;
    const SIN_CARGO_PASARELA = 2;
    
    const IVA_INCLUIDO = 0;
    const AGREGAR_IVA = 1;
    const SIN_IVA = 2;
    
    const LONG_NUM_FACTURA = 15;
    
    
    //Estados de proceso Pagadito
    const REGISTRADO = 'REGISTERED';
    const COMPLETADO = 'COMPLETED';
    const VERIFICADO = 'VERIFYING';
    const REVOCADO = 'REVOKED';
    const FALLIDO = 'FAILED';
    const CANCELADO = 'CANCELED';
    const EXPIRADO = 'EXPIRED';
    
    //Estados de proceso de Link externo
    const LINK_PENDIENTE = 'PENDIENTE';
    const LINK_COMPLETADO = 'COMPLETADO';
    
    public static $estados_link = [self::LINK_PENDIENTE => 'Pendiente', self::LINK_COMPLETADO => 'Completado']; 
    
    /**
     * {@inheritdoc}
     */
    public static function tableName() {
        return 'cobro_pagadito';
    }
    
    /**
     * {@inheritdoc}
     */
    public function rules(){
        return [
            [['id_cita', 'n_factura', 'total_cita', 'notas', 'iva', 'cargo_pasarela', 'cargar_iva', 'fecha_cobro'], 'required', 'message'=> 'El campo \'{attribute}\' no puede quedar vacío.'],
            [['fecha_pago', 'estado', 'total_cobrado', 'token'], 'safe'],
            [['tipo'], 'integer'],
            [['id_cita'], 'exist', 'skipOnError' => true, 'targetClass' => Cita::className(), 'targetAttribute' => ['id_cita' => 'id']]
        ];
    }
    
    /**
     * {@inheritdoc}
     */
    public function attributeLabels() {
        return [
            'id' => 'ID',
            'id_cita' => 'ID Cita',
            'total_cita' => 'Total Cita',
            'cargo_pasarela' => 'Cargo Pasarela',
            'id_suscripcion' => 'ID Suscripción',
            'cargar_iva' => 'Cargar IVA',
            'iva' => 'IVA',
            'total_cobrado' => 'Total Cobrado',
            'metodo_cobro' => 'Metodo Cobro',
            'notas' => 'Notas',
            'fecha_cobro' => 'Fecha Cobro',
            'fecha_pago' => 'Fecha Pago',
            'estado' => 'Estado',
            'tipo' => 'Tipo'
        ];
    }
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCita()
    {
        return $this->hasOne(Cita::className(), ['id' => 'id_cita']);
    }
    
    /**
     * @return string
     */
    public function getUrlCobro()
    {
        return \Yii::$app->params['shortUrlServer'].'c/i?t='.$this->token;
    }
    
    public function getTextoEstado()
    {
        switch ($this->estado){
            case null:
                return '<span class="kt-badge kt-badge--brand kt-badge--inline kt-badge--pill kt-badge--rounded">En espera</span>';
            case self::COMPLETADO:
                return '<span class="kt-badge kt-badge--success kt-badge--inline kt-badge--pill kt-badge--rounded">Completado</span>';
            case self::REGISTRADO:
                return '<span class="kt-badge kt-badge--brand kt-badge--inline kt-badge--pill kt-badge--rounded">Registrado</span>';
            case self::VERIFICADO :
                return '<span class="kt-badge kt-badge--success kt-badge--inline kt-badge--pill kt-badge--rounded">Verificado</span>';
            case self::REVOCADO :
                return '<span class="kt-badge kt-badge--warning kt-badge--inline kt-badge--pill kt-badge--rounded">Revocado</span>';
            case self::FALLIDO :
                return '<span class="kt-badge kt-badge--danger kt-badge--inline kt-badge--pill kt-badge--rounded">Fallido</span>';
            case self::CANCELADO :
                return '<span class="kt-badge kt-badge--danger kt-badge--inline kt-badge--pill kt-badge--rounded">Cancelado</span>';
            case self::EXPIRADO :
                return '<span class="kt-badge kt-badge--danger kt-badge--inline kt-badge--pill kt-badge--rounded">Expirado</span>';
        }
    }
}
