<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Cita;
use app\customs\Utils;

/**
 * CitaSearch represents the model behind the search form of `app\models\Cita`.
 */
class CitaSearch extends Cita
{
    /**
     * {@inheritdoc}
     */
    public $nombrePaciente;
    
    public function rules()
    {
        return [
            [['id', 'id_suscripcion', 'id_paciente', 'estado', 'tiempo_estimado', 'id_clinica'], 'integer'],
            [['fecha', 'asunto', 'diagnostico', 'receta','nombrePaciente'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params,$query,$c)
    {
        $query = Cita::find()->where($query);
        $query = Utils::filtrarPorClinicas($c,$query);
        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);
        
        $dataProvider->setSort([
            'defaultOrder' => ['fecha' => SORT_DESC],
            'attributes' => [
                'id',
                'nombrePaciente' => [
                    'asc' => ['paciente.nombre' => SORT_ASC,'paciente.apellido' => SORT_ASC],
                    'desc' => ['paciente.nombre' => SORT_DESC,'paciente.apellido' => SORT_DESC],
                    'label' => 'Nombre',
                    'default' => SORT_ASC
                ],
                'nombreClinica' => [
                    'asc' => ['clinica.nombre' => SORT_ASC],
                    'desc' => ['clinica.nombre' => SORT_DESC],
                    'label' => 'Clinica',
                    'default' => SORT_ASC
                ],
                'textoEstado' => [
                    'asc' => ['estado' => SORT_ASC],
                    'desc' => ['estado' => SORT_DESC],
                    'label' => 'Estado',
                    'default' => SORT_ASC
                ],
                'fecha',
                'estado'
            ]
        ]);

        //$this->load($params);
        if (!($this->load($params) && $this->validate())) {
            /**
             * The following line will allow eager loading with country data 
             * to enable sorting by country on initial loading of the grid.
             */ 
            $query->joinWith(['paciente']);
            $query->joinWith(['clinica']);
            return $dataProvider;
        }

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'id_suscripcion' => $this->id_suscripcion,
            'fecha' => $this->fecha,
            'id_paciente' => $this->id_paciente,
            'estado' => $this->estado,
            'tiempo_estimado' => $this->tiempo_estimado,
            'id_clinica' => $this->id_clinica,
        ]);

        $query->andFilterWhere(['like', 'asunto', $this->asunto])
            ->andFilterWhere(['like', 'diagnostico', $this->diagnostico])
            ->andFilterWhere(['like', 'receta', $this->receta]);

        return $dataProvider;
    } 
 }
