<?php 

namespace app\models;

use Yii;

/**
 * This is the model class for table "cita_adjunto".
 *
 * @property int $id
 * @property int $id_cita
 * @property int $id_adjunto
 * @property int $tipo
 * @property Cita $cita
 * @property Adjunto $adjunto	 
 */
class CitaAdjunto extends \yii\db\ActiveRecord
{
    const TIPO_IMG = 1;
    const TIPO_PDF = 2;
    const TIPO_DOC = 3;
    const TIPO_XLS = 4;

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
            return 'cita_adjunto';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
            return [
                [['id_cita','id_adjunto', 'tipo'],'required'],
                [['id_cita','id_adjunto', 'tipo'],'integer'],
                [['id_cita'], 'exist', 'skipOnError' => true, 'targetClass' => Cita::className(), 'targetAttribute' => ['id_cita' => 'id']],
                [['id_adjunto'], 'exist', 'skipOnError' => true, 'targetClass' => Adjunto::className(), 'targetAttribute' => ['id_adjunto' => 'id']],
            ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'id_cita' => 'Id Cita',
            'id_adjunto' => 'Id Adjunto'
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCita()
    {
        return $this->hasOne(Cita::className(), ['id' => 'id_cita']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAdjunto()
    {
        return $this->hasOne(Adjunto::className(), ['id' => 'id_adjunto']);
    }
}

