<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "bitacora_seguimiento".
 *
 * @property int $id
 * @property int $id_seguimiento
 * @property string $fecha_incidencia
 * @property string $fecha_seguimiento
 * @property int $id_usuario
 * @property Seguimiento $seguimiento
 * @property string $interaccion
 * @property string $comentario
 * @property string $fechaIncidenciaDB
 */
class BitacoraSeguimiento extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    
    public $hasFormat = false;
    
    public static function tableName()
    {
        return 'bitacora_seguimiento';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_seguimiento', 'fecha_incidencia', 'interaccion'], 'required','message'=>'El campo \'{attribute}\' no puede quedar vacío.'],
            [['id_usuario', 'id_seguimiento'], 'integer'],
            [['fecha_seguimiento', 'comentario'], 'safe'],
            [['interaccion'], 'string', 'max' => 500],
            [['id_seguimiento'], 'exist', 'skipOnError' => true, 'targetClass' => Seguimiento::className(), 'targetAttribute' => ['id_seguimiento' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'id_seguimiento' => 'ID seguimiento',
            'fecha_incidencia' => 'Fecha de incidencia',
            'interaccion' => 'Interaccion',
            'id_usuario' => 'ID usuario'
            
        ];
    }
    
    
    public function afterFind(){
        $fecha = $this->fecha_incidencia;
        $fechaS = $this->fecha_seguimiento;
        if(!is_null($fecha) && !empty($fecha)){
            $fecha_f = \DateTime::createFromFormat('Y-m-d H:i:s', $fecha)->format('d/m/Y H:i:s');
            $this->fecha_incidencia = $fecha_f;
            $this->hasFormat = false;
        }
        if(!is_null($fechaS) && !empty($fechaS)){
            $fecha_Sf = \DateTime::createFromFormat('Y-m-d', $fechaS)->format('d/m/Y');
            $this->fecha_seguimiento = $fecha_Sf;
            $this->hasFormat = false;
        }
    }
    
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSeguimiento()
    {
        return $this->hasOne(Seguimiento::className(), ['id' => 'id_seguimiento']);
    }
    
    public function getFechaIncidenciaDB()
    {
       if(!$this->hasFormat){
            return \DateTime::createFromFormat('d/m/Y H:i:s', $this->fecha_incidencia)->format('Y-m-d H:i:s');
        }
        return $this->fecha_incidencia;
    }
    
}