<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "bitacora_paciente".
 *
 * @property int $id
 * @property int $id_paciente
 * @property string $fecha
 * @property int $estado
 * @property int $id_usuario
 * @property int $id_grupo
 * @property int $id_clinica
 *
 * @property Clinica $clinica
 * @property GrupoTrabajo $grupo
 * @property Paciente $paciente
 * @property Usuario $usuario
 */
class BitacoraPaciente extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'bitacora_paciente';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_paciente', 'fecha', 'estado', 'id_usuario'], 'required'],
            [['id_paciente', 'estado', 'id_usuario', 'id_grupo', 'id_clinica'], 'integer'],
            [['fecha'], 'safe'],
            [['id_clinica'], 'exist', 'skipOnError' => true, 'targetClass' => Clinica::className(), 'targetAttribute' => ['id_clinica' => 'id']],
            [['id_grupo'], 'exist', 'skipOnError' => true, 'targetClass' => GrupoTrabajo::className(), 'targetAttribute' => ['id_grupo' => 'id']],
            [['id_paciente'], 'exist', 'skipOnError' => true, 'targetClass' => Paciente::className(), 'targetAttribute' => ['id_paciente' => 'id']],
            [['id_usuario'], 'exist', 'skipOnError' => true, 'targetClass' => Usuario::className(), 'targetAttribute' => ['id_usuario' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'id_paciente' => 'Id Paciente',
            'fecha' => 'Fecha',
            'estado' => 'Estado',
            'id_usuario' => 'Id Usuario',
            'id_grupo' => 'Id Grupo',
            'id_clinica' => 'Id Clinica',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getClinica()
    {
        return $this->hasOne(Clinica::className(), ['id' => 'id_clinica']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGrupo()
    {
        return $this->hasOne(GrupoTrabajo::className(), ['id' => 'id_grupo']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPaciente()
    {
        return $this->hasOne(Paciente::className(), ['id' => 'id_paciente']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUsuario()
    {
        return $this->hasOne(Usuario::className(), ['id' => 'id_usuario']);
    }
}
