<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "bitacora_mensaje_libre".
 *
 * @property int $id
 * @property int $id_suscripcion
 * @property string $mensaje
 * @property string $fecha
 * @property int $id_usuario
 * @property bool $es_email
 * @property bool $es_sms
 *
 * @property Suscripcion $suscripcion
 * @property Usuario $usuario
 * @property BitacoraMensajePaciente[] $bitacoraMensajePacientes
 */
class BitacoraMensajeLibre extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'bitacora_mensaje_libre';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_suscripcion', 'id_usuario'], 'required'],
            [['id_suscripcion', 'id_usuario'], 'integer'],
            [['fecha'], 'safe'],
            [['es_email', 'es_sms'], 'boolean'],
            [['mensaje'], 'string', 'max' => 1000],
            [['id_suscripcion'], 'exist', 'skipOnError' => true, 'targetClass' => Suscripcion::className(), 'targetAttribute' => ['id_suscripcion' => 'id']],
            [['id_usuario'], 'exist', 'skipOnError' => true, 'targetClass' => Usuario::className(), 'targetAttribute' => ['id_usuario' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'id_suscripcion' => 'Id Suscripcion',
            'mensaje' => 'Mensaje',
            'fecha' => 'Fecha',
            'id_usuario' => 'Id Usuario',
            'es_email' => 'Es Email',
            'es_sms' => 'Es Sms',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSuscripcion()
    {
        return $this->hasOne(Suscripcion::className(), ['id' => 'id_suscripcion']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUsuario()
    {
        return $this->hasOne(Usuario::className(), ['id' => 'id_usuario']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBitacoraMensajePacientes()
    {
        return $this->hasMany(BitacoraMensajePaciente::className(), ['id_bitacora_mensaje' => 'id']);
    }
}
