<?php 

namespace app\models;

use Yii;
/**
 * This is the model class for table "adjunto".
 *
 * @property int $id
 * @property string $descripcion
 * @property string $adjunto_src_nombre
 * @property string $adjunto_web_ruta
 * @property int $tipo
 * @property string $adjuntoDescripcion
 * @property string $rutaTipo
 * @property string $rutaExtension
 * @property string $urlAdjunto  
 *
 */
class Adjunto extends \yii\db\ActiveRecord
{
    public $adjunto;
    const TIPO_IMG = 1;
    const TIPO_PDF = 2;
    const TIPO_DOC = 3;
    const TIPO_XLS = 4;
    const EXT_PNG = 'png';
    const EXT_JPG = 'jpg';
    const EXT_JPEG = 'jpeg';
    const EXT_GIF = 'gif';
    const EXT_PDF = 'pdf';
    const EXT_DOC = 'doc';
    const EXT_DOCX = 'docx';
    const EXT_XLS = 'xls';
    const EXT_XLSX = 'xlsx';
    
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
            return 'adjunto';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
            return [
                [['descripcion'], 'safe'],
                [['descripcion'],  'string', 'max' => 200],
                [['adjunto'],'file', 
                    'extensions'=> ['jpg', 'gif', 'png', 'jpeg', 'pdf', 'doc', 'docx', 'xlsx', 'xls'],
                    'maxSize' => 600*600, 
                    'maxFiles' => 6, 
                    'mimeTypes'=>['image/*','application/*'],
                    'maxSize' => 1024*1024*3, 
                    'tooBig' => 'El tamaño máximo permitido es 5MB',
                ],
                [['adjunto_src_nombre', 'adjunto_web_ruta'], 'string', 'max' => 255],
                [['tipo'],'safe'],
                [['tipo'],'integer'],
            ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'descripcion' => 'Descripcion',
            'adjunto_src_nombre' => 'Nombre de archivo',
            'adjunto_web_ruta' => 'Ruta de archivo',
        ];
    }
    
    /**
     * @param objet $model 
     * @return objet  
     */
    public static function subirAdjunto($model){
        $usuario = Yii::$app->user->identity;
        $idS = $usuario->suscripcion->id;
        $adjunto = UploadedFile::getInstances($model, 'adjunto');
        if(!is_null($adjunto)){
            $nombreExt = explode(".", $adjunto->name );
            $ext = $nombreExt[1];
            $model->tipo = Adjunto::getTipoAdjunto($ext);
            $model->adjunto_src_nombre = $nombreExt[0].'_'.$idS.Yii::$app->security->generateRandomString(5).".{$ext}";
            $model->adjunto_web_ruta = Yii::$app->security->generateRandomString().".{$ext}";
            Yii::$app->params['uploadPath'] = Yii::$app->basePath.Yii::$app->params['urlAdjuntoCita'].Adjunto::getRutaExtension($ext);
            $path = Yii::$app->params['uploadPath'] . $model->adjunto_src_nombre;
            $adjunto->saveAs($path);
            if($model->save()){
                return $model;
            }
        }
        
    }
    
    public function getAdjuntoDescripcion(){
        return $this->descripcion == null ? 'No definido' : $this->descripcion; 
    }
    
    public function getUrlAdjunto(){
        return Yii::$app->homeUrl.$this->rutaTipo.$this->adjunto_src_nombre;
    }
    
    public function getRutaTipo(){
        switch ($this->tipo){
            case Adjunto::TIPO_IMG: 
                return Yii::$app->params['srcAdjuntoImg']; 
            case Adjunto::TIPO_PDF: 
                return Yii::$app->params['srcAdjuntoPdf']; 
            case Adjunto::TIPO_DOC: 
                return Yii::$app->params['srcAdjuntoDoc']; 
            case Adjunto::TIPO_XLS: 
                return Yii::$app->params['srcAdjuntoXls']; 
        }
        
        
    }
    
    public static function getRutaExtension($ext){
        switch ($ext){
            case Adjunto::EXT_PDF: 
                return Yii::$app->params['urlAdjuntoPdf']; 
            case Adjunto::EXT_DOC: 
                return Yii::$app->params['urlAdjuntoDoc'];
            case Adjunto::EXT_DOCX: 
                return Yii::$app->params['urlAdjuntoDoc'];     
            case Adjunto::EXT_XLS: 
                return Yii::$app->params['urlAdjuntoXls'];
            case Adjunto::EXT_XLSX: 
                return Yii::$app->params['urlAdjuntoXls'];         
            default: 
                return Yii::$app->params['urlAdjuntoImg']; 
        }
    }
    
    public static function getTipoAdjunto($ext){
        switch ($ext){
            case Adjunto::EXT_PDF: 
                return Adjunto::TIPO_PDF; 
            case Adjunto::EXT_DOC: 
                return Adjunto::TIPO_DOC;
            case Adjunto::EXT_DOCX: 
                return Adjunto::TIPO_DOC;     
            case Adjunto::EXT_XLS: 
                return Adjunto::TIPO_XLS;
            case Adjunto::EXT_XLSX: 
                return Adjunto::TIPO_XLS;   
            default: 
                return Adjunto::TIPO_IMG; 
        }
    }
    
}


