<?php
use app\models\Cita;
use app\models\Suscripcion;

/* @var $model app\models\Cita */
/* @var $urlCita app\models\UrlCita */
/* @var $urlConfirmacion string */
/* @var $suscripcion app\models\Suscripcion */

$suscripcion = $model->clinica->suscripcion;


 
$urlRecordatorio = Yii::$app->params['shortUrlServer'];
$urlLink = $urlRecordatorio ."?" . $urlCita->llave;
?>
<div style="width: 560px; height: 400px; background: #fff;border-radius: 5px;margin: auto; padding: 50px 0;">
    <h2 style="color:#444F60;margin: 0px; font-size: 24px;font-weight: bold;">
        Hola <?=$model->paciente->primerNombre?>
    </h2>
    <?php if($model->estado == Cita::CONFIRMADA){ ?>
    <p style="font-size: 14px; font-weight: bold; color: grey">
        La cita que confirmaste con <?=$articulo?> se aproxima. A continuación el detalle de la misma:<br>
    </p>
    <?php } else{ ?>
    <p style="font-size: 14px; font-weight: bold; color: grey">
        La cita con <?=$articulo?> se aproxima. A continuación el detalle de la misma:<br>
    </p>
    <?php } ?>
    <ul>
        <li style="font-size: 14px; font-weight: bold; color: grey">Fecha:&nbsp;<?=explode(' ',$model->fecha)[0]?></li>
        <li style="font-size: 14px; font-weight: bold; color: grey">Hora:&nbsp;<?=date('g:i A', strtotime($model->fechaDB) )?>(CST)</li>
        <?php if( $suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL ): //mostrar el nombre de la clínica si es suscripción individual ?>
        <li style="font-size: 14px; font-weight: bold; color: grey">Clínica:&nbsp;<?=$model->clinica->nombre?></li>
        <?php endif; ?>
        <?php if( $suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL && $model->tipo_cita == Cita::CITA_PRESENCIAL ):?>
        <li style="font-size: 14px; font-weight: bold; color: grey">Ubicación:&nbsp;<?=$model->clinica->direccion?></li>
        <?php endif;?>
        <?php if($model->tipo_cita == Cita::CITA_EN_LINEA && !empty( $linkTeleconsulta ) ):?>
        <li style="font-size: 14px; font-weight: bold; color: grey">Medio de Consulta:&nbsp;<?=$linkTeleconsulta?></li>
        <?php endif;?>
    </ul>
    <?php if($model->estado == Cita::CONFIRMADA) { ?>
    <p style="font-size: 14px; font-weight: bold; color: grey">Recuerda presentarte a la hora indicada. Si ocurre algún imprevisto, ponte en contacto con tu clínica<?=$model->clinica->telefono != null ? ' al '.$model->clinica->telefono.'.' : '.' ?>
        <br>
    </p>
    <?php } else { ?>
    <?php if( boolval($llave->valor) ){//permitir reprogramación activa ?>    
    <p style="font-size: 14px; font-weight: bold; color: grey">Confirma o reprograma tu cita haciendo clíck <a href="<?= $urlLink?>"><?= $urlLink?></a><br></p>
    <?php }else{ ?>
    <p style="font-size: 14px; font-weight: bold; color: grey">Confirma tu cita haciendo clíck <a href="<?= $urlLink?>"><?= $urlLink?></a><br></p>
    <?php } ?>
    <p style="font-size: 14px; font-weight: bold; color: grey">Se recomienda siempre confirmar tus citas para que tu doctor(a) pueda brindarte una mejor atención.<br></p>
    <?php } ?>
    <p style="font-size: 16px; font-weight: bold; color: #444F60">
        Atentamente,
    </p>
     <p style="font-size: 16px; font-weight: bold; color: #444F60; margin-top: -40px;">
         El Equipo de Olivia
    </p>
 </div>
<?=$this->render("footer-correo")?>