<?php
use app\models\Cita;
use app\models\Suscripcion;

/* @var $model app\models\Cita */
/* @var $suscripcion app\models\Suscripcion */

$suscripcion = $model->clinica->suscripcion;

?>
<div style="width: 560px; height: 400px; background: #fff;border-radius: 5px;margin: auto; padding: 50px 0;">
    <h2 style="color:#444F60;margin: 0px; font-size: 24px;font-weight: bold;">
        Hola <?=$model->paciente->nombreCortoEncargado?>
    </h2>
    <?php if($model->estado == Cita::CONFIRMADA){ ?>
    <p style="font-size: 14px; font-weight: bold; color: grey">
        La cita que el paciente <?=$model->paciente->nombreCorto?> confirmó con <?=$articulo?> se aproxima. A continuación el detalle de la misma:<br>
    </p>
    <?php } else{ ?>
    <p style="font-size: 14px; font-weight: bold; color: grey">
        La cita del paciente <?=$model->paciente->nombreCorto?> con <?=$articulo?> se aproxima. A continuación el detalle de la misma:<br>
    </p>
    <?php } ?>
    <ul>
        <li style="font-size: 14px; font-weight: bold; color: grey">Fecha:&nbsp;<?=explode(' ',$model->fecha)[0]?></li>
        <li style="font-size: 14px; font-weight: bold; color: grey">Hora:&nbsp;<?=date('g:i A', strtotime($model->fechaDB) )?>(CST)</li>
        <?php if( $suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL ): //mostrar el nombre de la clínica si es suscripción individual ?>
        <li style="font-size: 14px; font-weight: bold; color: grey">Clínica:&nbsp;<?=$model->clinica->nombre?></li>
        <?php endif; ?>
        <?php if( $suscripcion->tipo == Suscripcion::TIPO_INDIVIDUAL && $model->tipo_cita == Cita::CITA_PRESENCIAL ):?>
        <li style="font-size: 14px; font-weight: bold; color: grey">Ubicación:&nbsp;<?=$model->clinica->direccion?></li>
        <?php endif;?>
        <?php if($model->tipo_cita == Cita::CITA_EN_LINEA && $linkTeleconsulta != null):?>
        <li style="font-size: 14px; font-weight: bold; color: grey">Medio de Consulta:&nbsp;<?=$linkTeleconsulta?></li>
        <?php endif;?>
    </ul>
    
    <p style="font-size: 14px; font-weight: bold; color: grey">
        Recuerda que el paciente debe llegar a tiempo a su cita. 
        Si ocurre algún imprevisto, ponerse en contacto con su clínica<?=$model->clinica->telefono != null ? ' al '.$model->clinica->telefono : '.' ?>
        <br>
    </p>
   
    <p style="font-size: 16px; font-weight: bold; color: #444F60">
        Atentamente,
    </p>
     <p style="font-size: 16px; font-weight: bold; color: #444F60; margin-top: -40px;">
         El Equipo de Olivia
    </p>
 </div>
<?=$this->render("footer-correo")?>